/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.ReloadableUnitsInit;
import com.endertech.minecraft.mods.adpother.sources.AnimalBurning;
import com.endertech.minecraft.mods.adpother.sources.AnimalDying;
import com.endertech.minecraft.mods.adpother.sources.AnimalFeeding;
import com.endertech.minecraft.mods.adpother.sources.Explosion;
import com.endertech.minecraft.mods.adpother.sources.HostileMobBurning;
import com.endertech.minecraft.mods.adpother.sources.HostileMobDying;
import com.endertech.minecraft.mods.adpother.sources.LavaTouchingWater;
import com.endertech.minecraft.mods.adpother.sources.PlayerBurning;
import com.endertech.minecraft.mods.adpother.sources.PlayerDying;
import com.endertech.minecraft.mods.adpother.sources.PlayerEating;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public class Sources
extends ReloadableUnitsInit<SourceBase> {
    public final Map<String, ForgeConfigSpec.ConfigValue<Boolean>> enabled = new HashMap<String, ForgeConfigSpec.ConfigValue<Boolean>>();
    public Lazy<Explosion> explosion;
    public Lazy<LavaTouchingWater> lavaTouchingWater;
    public Lazy<AnimalBurning> animalBurning;
    public Lazy<AnimalDying> animalDying;
    public Lazy<AnimalFeeding> animalFeeding;
    public Lazy<HostileMobBurning> hostileMobBurning;
    public Lazy<HostileMobDying> hostileMobDying;
    public Lazy<PlayerBurning> playerBurning;
    public Lazy<PlayerDying> playerDying;
    public Lazy<PlayerEating> playerEating;

    public Sources(AbstractForgeMod mod) {
        super(mod);
    }

    protected <T extends SourceBase> Lazy<T> addNew(String name, Factory<T> factory) {
        return this.addUnit(name, () -> (SourceBase)((Object)((Object)factory.create(this.createConfig(name)))));
    }

    protected final void init() {
        this.explosion = this.addNew("explosion", Explosion::new);
        this.lavaTouchingWater = this.addNew("lava_touching_water", LavaTouchingWater::new);
        this.animalBurning = this.addNew("animal_burning", AnimalBurning::new);
        this.animalDying = this.addNew("animal_dying", AnimalDying::new);
        this.animalFeeding = this.addNew("animal_feeding", AnimalFeeding::new);
        this.hostileMobBurning = this.addNew("hostile_mob_burning", HostileMobBurning::new);
        this.hostileMobDying = this.addNew("hostile_mob_dying", HostileMobDying::new);
        this.playerBurning = this.addNew("player_burning", PlayerBurning::new);
        this.playerDying = this.addNew("player_dying", PlayerDying::new);
        this.playerEating = this.addNew("player_eating", PlayerEating::new);
    }

    public void onPostInit() {
        super.onPostInit();
        this.mapAll().forEach((name, source) -> ((SourceBase)((Object)((Object)source.get()))).setEnabled((Boolean)this.enabled.get(name).get()));
    }

    static interface Factory<T> {
        public T create(UnitConfig var1);
    }
}

