/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.client.renderer.ClientItemExtensions;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renderers.AerometerRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeConfigSpec;

public class Aerometer
extends GlassMeter {
    public static final float THICKNESS = 0.08f;
    public static final int GAS_DETECTION_RADIUS = 8;
    public static ForgeConfigSpec.ConfigValue<Integer> beepInterval;
    public static ForgeConfigSpec.ConfigValue<Double> beepVolume;
    public static ForgeConfigSpec.ConfigValue<Double> beepPitch;
    private CommonTime.Stamp lastCleaning;

    public Aerometer(UnitConfig config, GlassMeter.Properties<?> props) {
        super(config, props);
    }

    public static Optional<Entity> getCarrierFor(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof Aerometer) {
            Aerometer meter = (Aerometer)item;
            return Optional.ofNullable((Entity)meter.carriers.get(stack));
        }
        return Optional.empty();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept((IClientItemExtensions)ClientItemExtensions.of(AerometerRenderer::new));
    }

    public static List<ItemStack> findInInventoryOf(Player player) {
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!(stack.m_41720_() instanceof Aerometer)) continue;
            found.add(stack);
        }
        return found;
    }

    public static List<ItemStack> findInHandsOf(Player player) {
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_6167_()) {
            if (!(stack.m_41720_() instanceof Aerometer)) continue;
            found.add(stack);
        }
        return found;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        this.updateClientSideCarrier(stack, entity);
    }

    public void updateClientSideCarrier(ItemStack stack, Entity entity) {
        if (ForgeEntity.isClientSide((Entity)entity) && ForgeItem.notBroken((ItemStack)stack)) {
            this.carriers.put(stack, entity);
            if (this.lastCleaning == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastCleaning).moreThan(CommonTime.Interval.seconds((double)10.0))) {
                this.cleanUselessStacks();
                this.lastCleaning = CommonTime.Stamp.now();
            }
        }
    }

    public boolean isClientSideCarrier(Entity entity) {
        for (Map.Entry entry : this.carriers.entrySet()) {
            ItemStack stack = (ItemStack)entry.getKey();
            Entity carrier = (Entity)entry.getValue();
            if (!entity.equals((Object)carrier) || !ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (GameTime.seconds((int)4).noShift().pastFor((Entity)entity)) {
                WorldData.SyncEntityPollutionWithClientsAround(level2, (Entity)entity);
            }
        }
        this.updateClientSideCarrier(stack, (Entity)entity);
        return false;
    }

    private void cleanUselessStacks() {
        Iterator iterator = this.carriers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ItemStack stack = (ItemStack)entry.getKey();
            Entity entity = (Entity)entry.getValue();
            if (!stack.m_41619_() && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
            iterator.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag flag) {
        Tooltip tip = Tooltip.of((AbstractForgeMod)AdPother.getInstance(), (String)"aerometer", lines);
        if (tip.showDetails()) {
            tip.add(ChatFormatting.DARK_AQUA, "gas_detection_radius", (Object)8);
            tip.add("needles", new Object[]{ChatFormatting.RESET, ChatFormatting.YELLOW});
            tip.add("red_triangle", new Object[]{ChatFormatting.RESET, ChatFormatting.RED});
            tip.add("beeps", new Object[]{ChatFormatting.RESET, ChatFormatting.DARK_AQUA});
            tip.add("threshold", new Object[]{ChatFormatting.RESET, ChatFormatting.DARK_PURPLE});
        } else {
            Optional<Entity> carrier;
            if (Aerometer.notBroken((ItemStack)stack) && (carrier = Aerometer.getCarrierFor(stack)).isPresent()) {
                EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
                pollution.getInfos().map(PollutionInfo::getPollutant).forEach(pollutant -> tip.addRaw(pollutant.getTextColor() + pollutant.m_49954_().getString() + ": " + pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toColoredText()));
            }
            tip.addEmptyLine();
            tip.holdShiftForDetails();
        }
        super.m_7373_(stack, level, lines, flag);
    }
}

