/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.init.Sounds;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class GasDetection {
    public static final IntBounds GAS_BLOCKS_THRESHOLD = IntBounds.between((Integer)1, (Integer)8);
    public static final Result EMPTY_RESULT = new Result(false, 0);
    protected final Entity entity;
    protected final int radius;
    protected CompletableFuture<Result> computedResult = CompletableFuture.completedFuture(EMPTY_RESULT);
    protected Result lastComputedResult = EMPTY_RESULT;
    protected CommonTime.Stamp lastBeep = CommonTime.Stamp.now();
    protected AlarmLevel lastBeepedAlarmLevel = AlarmLevel.NONE;

    public GasDetection(Entity entity, int radius) {
        this.entity = entity;
        this.radius = radius;
    }

    public Level getLevel() {
        return this.entity.m_9236_();
    }

    public BlockPos getStartPos() {
        return this.entity.m_20183_();
    }

    public WorldBounds getSearchBounds() {
        return WorldBounds.from((BlockPos)this.getStartPos().m_7918_(-this.radius, -this.radius, -this.radius), (BlockPos)this.getStartPos().m_7918_(this.radius, this.radius, this.radius));
    }

    public void update() {
        if (this.entity.m_6084_() && ((Aerometer)((Object)AdPother.getInstance().items.aerometer.get())).isClientSideCarrier(this.entity)) {
            if (this.computedResult.isDone()) {
                this.computedResult = CompletableFuture.supplyAsync(() -> new Searcher((LevelAccessor)this.getLevel(), this.getStartPos(), this.getSearchBounds()).buildWithResult());
            }
            this.beepIfGasDetected();
        } else {
            this.lastComputedResult = EMPTY_RESULT;
        }
    }

    public Result getResult() {
        this.lastComputedResult = this.computedResult.getNow(this.lastComputedResult);
        return this.lastComputedResult;
    }

    public AlarmLevel getAlarmLevel() {
        Result result = this.getResult();
        if (result.explosionRisk()) {
            return AlarmLevel.HIGH;
        }
        if (result.gasBlocksAround() >= GAS_BLOCKS_THRESHOLD.getMax()) {
            return AlarmLevel.MEDIUM;
        }
        if (result.gasBlocksAround() > 0) {
            return AlarmLevel.LOW;
        }
        return AlarmLevel.NONE;
    }

    protected void beepIfGasDetected() {
        if (this.getLevel().m_5776_()) {
            AlarmLevel alarmLevel;
            int threshold;
            int beepInterval = (Integer)Aerometer.beepInterval.get();
            Entity entity = this.entity;
            if (entity instanceof ItemFrame) {
                ItemFrame frame = (ItemFrame)entity;
                v0 = frame.m_31823_() + 1;
            } else {
                v0 = threshold = GAS_BLOCKS_THRESHOLD.getMin().intValue();
            }
            if (beepInterval > 0 && this.getResult().gasBlocksAround() >= threshold && ((alarmLevel = this.getAlarmLevel()).ordinal() > this.lastBeepedAlarmLevel.ordinal() || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastBeep).moreThan(CommonTime.Interval.seconds((double)beepInterval)))) {
                float volume = ((Double)Aerometer.beepVolume.get()).floatValue();
                float pitch = ((Double)Aerometer.beepPitch.get()).floatValue();
                this.getLevel().m_245747_(this.getStartPos(), this.getBeepSound(), SoundSource.NEUTRAL, volume, pitch, false);
                this.lastBeep = CommonTime.Stamp.now();
                this.lastBeepedAlarmLevel = alarmLevel;
            }
        }
    }

    protected SoundEvent getBeepSound() {
        Sounds sounds = AdPother.getInstance().sounds;
        return switch (this.getAlarmLevel()) {
            case AlarmLevel.HIGH -> (SoundEvent)sounds.beep_x3.get();
            case AlarmLevel.MEDIUM -> (SoundEvent)sounds.beep_x2.get();
            default -> (SoundEvent)sounds.beep_x1.get();
        };
    }

    public record Result(boolean explosionRisk, int gasBlocksAround) {
    }

    public static enum AlarmLevel {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static class Searcher
    extends WorldSearch.BlockChain {
        protected final WorldBounds searchBounds;
        protected boolean explosionRisk;

        public Searcher(LevelAccessor level, BlockPos startPos, WorldBounds searchBounds) {
            super(level, startPos, searchBounds.size());
            this.searchBounds = searchBounds;
        }

        protected boolean isOutsideBounds(BlockPos pos) {
            if (!this.searchBounds.encloses(pos)) {
                return true;
            }
            return super.isOutsideBounds(pos);
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.level.m_46859_(pos)) {
                return true;
            }
            if (this.lastUsedDirection == null) {
                return true;
            }
            BlockPos last = pos.m_121945_(this.lastUsedDirection.m_122424_());
            return !this.level.m_8055_(last).m_60783_((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.m_8055_(pos).m_60783_((BlockGetter)this.level, pos, this.lastUsedDirection.m_122424_());
        }

        protected boolean isValidBlock(BlockPos pos) {
            return this.level.m_8055_(pos).m_60734_() instanceof AbstractGas;
        }

        protected boolean onValidFound(BlockPos blockPos) {
            if (!this.explosionRisk) {
                this.explosionRisk = GasExplosion.in(this.level).position(blockPos).action(gasChain -> {
                    for (BlockPos pos : gasChain.getFound().elements()) {
                        if (this.foundEnoughGasBlocks()) break;
                        if (this.isOutsideBounds(pos)) continue;
                        this.getChain().add((Object)pos);
                        this.getFound().add((Object)pos);
                    }
                }).tryTrigger();
            }
            return !this.foundEnoughGasBlocks();
        }

        protected boolean foundEnoughGasBlocks() {
            return this.getFound().size() >= GAS_BLOCKS_THRESHOLD.getMax();
        }

        public Result buildWithResult() {
            this.build();
            return new Result(this.explosionRisk, this.getFound().size());
        }
    }
}

