/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PollutionParticle {

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends TextureSheetParticle {
        public Instance(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite, Percentage influence, Pollutant<?> pollutant) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.m_107250_(0.02f, 0.02f);
            this.f_107219_ = false;
            this.f_107215_ = xSpeed;
            this.f_107216_ *= (double)0.1f;
            this.f_107217_ = zSpeed;
            float factor = influence.toFraction();
            this.f_107663_ *= this.f_107223_.m_188501_() * 0.6f + 0.5f;
            this.f_107225_ = (int)(20.0 / ((double)this.f_107223_.m_188501_() * 0.8 + 0.2));
            this.f_107230_ = GameBounds.FACTOR.getFloatBounds().interpolateUp(factor).floatValue();
            this.m_108335_(sprite);
            ColorARGB color = pollutant.getColor();
            this.m_107253_(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107431_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<Data> {
        protected final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(Data data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Instance(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, data.influence, data.pollutant);
        }
    }

    public static class Deserializer
    implements ParticleOptions.Deserializer<Data> {
        public Data fromCommand(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new Data(Percentage.ZERO, null);
        }

        public Data fromNetwork(ParticleType<Data> particleTypeIn, FriendlyByteBuf buffer) {
            return new Data(Percentage.ZERO, null);
        }
    }

    public static class Data
    implements ParticleOptions {
        public final Percentage influence;
        public final Pollutant<?> pollutant;

        public Data(Percentage influence, Pollutant<?> pollutant) {
            this.influence = influence;
            this.pollutant = pollutant;
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)AdPother.getInstance().particles.pollution.get();
        }

        public void m_7711_(FriendlyByteBuf buffer) {
        }

        public String m_5942_() {
            return BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()).toString();
        }
    }
}

