/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.recipes;

import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class FilterChangeRecipe
extends CustomRecipe
implements INetSerializable<FilterChangeRecipe> {
    protected final AdPother mod;
    protected Map<Pollutant<?>, Set<Item>> filterMaterials;

    public FilterChangeRecipe(AdPother mod, ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
        this.mod = mod;
        this.filterMaterials = mod.pollutants.streamAll().collect(Collectors.toUnmodifiableMap(key -> key, pollutant -> pollutant.getFilterMaterials().getMaterials()));
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (this.getStorageItem(container).isEmpty()) {
            return false;
        }
        if (this.getTargetPollutants(container).isEmpty()) {
            return false;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_() || this.isFilterMaterial(itemStack) || !this.getStorageItem(itemStack).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack itemStack = this.getStorageItem(container).orElse(ItemStack.f_41583_).m_41777_();
        List<Pollutant<?>> targetPollutants = this.getTargetPollutants(container);
        if (!itemStack.m_41619_() && !targetPollutants.isEmpty()) {
            this.getStorageItem(itemStack).ifPresent(storage -> storage.installFiltersFor(itemStack, targetPollutants.toArray(new Pollutant[0])));
        }
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)this.mod.recipeSerializers.filterChange.get();
    }

    protected Optional<? extends IStorageItem> getStorageItem(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof VacuumBag) {
            VacuumBag item2 = (VacuumBag)item;
            return Optional.of(item2);
        }
        return this.mod.respirators.get(itemStack);
    }

    protected boolean isFilterMaterial(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return this.filterMaterials.values().stream().anyMatch(materials -> materials.contains(item));
    }

    protected Optional<ItemStack> getStorageItem(CraftingContainer container) {
        ItemStack foundItem = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!this.getStorageItem(itemStack).isPresent()) continue;
            if (foundItem.m_41619_()) {
                foundItem = itemStack;
                continue;
            }
            return Optional.empty();
        }
        return foundItem.m_41619_() ? Optional.empty() : Optional.of(foundItem);
    }

    protected List<? extends Pollutant<?>> getTargetPollutants(CraftingContainer container) {
        return this.filterMaterials.entrySet().stream().filter(entry -> container.m_18949_((Set)entry.getValue())).map(Map.Entry::getKey).toList();
    }

    public FilterChangeRecipe readFrom(FriendlyByteBuf buf) {
        CompoundTag compound = buf.m_130260_();
        if (compound != null) {
            this.filterMaterials = this.filterMaterials.keySet().stream().collect(Collectors.toUnmodifiableMap(k -> k, pollutant -> {
                String key = pollutant.getSimpleName();
                String[] strings = TagHelper.getStringArray((CompoundTag)compound, (String)key);
                return Stream.of(strings).map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
            }));
        }
        return this;
    }

    public FriendlyByteBuf writeTo(FriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        this.filterMaterials.forEach((pollutant, items) -> {
            String key = pollutant.getSimpleName();
            String[] strings = items.stream().map(ForgeItem::getRegistryName).map(ResourceLocation::toString).toList().toArray(new String[0]);
            TagHelper.putStringArray((CompoundTag)compound, (String)key, (String[])strings);
        });
        return buf.m_130079_(compound);
    }

    public static class Serializer
    implements RecipeSerializer<FilterChangeRecipe> {
        public final AdPother mod;

        public Serializer(AdPother mod) {
            this.mod = mod;
        }

        public FilterChangeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new FilterChangeRecipe(this.mod, recipeId);
        }

        @Nullable
        public FilterChangeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new FilterChangeRecipe(this.mod, recipeId).readFrom(buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, FilterChangeRecipe recipe) {
            recipe.writeTo(buffer);
        }
    }
}

