/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.EmitterWithCustomRate;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public abstract class AbstractRocket
extends EmitterWithCustomRate {
    public AbstractRocket(UnitConfig config, Emitter.Properties<?> props) {
        super(config, props);
    }

    public abstract int getMaxRadius();

    public abstract int getMaxEmitPositions();

    @Override
    public void emitAt(Level level, BlockPos startPos, float factor) {
        List<BlockPos> positions = AbstractRocket.findEmitPositions(level, startPos, this.getMaxRadius(), this.getMaxEmitPositions());
        for (BlockPos pos : positions) {
            super.emitAt(level, pos, factor / (float)positions.size());
        }
    }

    public static List<BlockPos> findEmitPositions(Level level, BlockPos startPos, int maxRadius, final int maxPositions) {
        IntBounds heightBounds = IntBounds.of((Integer)startPos.m_123342_()).extend(Integer.valueOf(maxRadius));
        WorldSearch.VertCylinder searcher = new WorldSearch.VertCylinder((LevelAccessor)level, startPos, heightBounds, maxRadius){

            protected boolean isValidPath(BlockPos pos) {
                if (this.level.m_46859_(pos)) {
                    return true;
                }
                if (this.lastUsedDirection == null) {
                    return true;
                }
                BlockPos last = pos.m_121945_(this.lastUsedDirection.m_122424_());
                return !this.level.m_8055_(last).m_60783_((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.m_8055_(pos).m_60783_((BlockGetter)this.level, pos, this.lastUsedDirection.m_122424_());
            }

            protected boolean isValidBlock(BlockPos pos) {
                return this.level.m_46859_(pos);
            }

            protected boolean onValidFound(BlockPos pos) {
                return this.getFound().size() < maxPositions;
            }
        };
        searcher.build();
        return searcher.getFound().elements();
    }
}

