/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.FloatBounds;
import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class CommonMath {
    public static final double ALMOST_ZERO = 1.0E-4;
    public static final Random RANDOM = new Random();

    public static boolean isAlmostZero(double value) {
        return Math.abs(value) < 1.0E-4;
    }

    public static boolean notZero(double value) {
        return !CommonMath.isAlmostZero(value);
    }

    public static double getAverage(double a, double b) {
        return (a + b) / 2.0;
    }

    public static double getAverage(double a, double b, double c) {
        return (a + b + c) / 3.0;
    }

    public static long getFloor(double a) {
        long i = (long)a;
        return (double)i > a ? i - 1L : i;
    }

    public static int getFloor(float a) {
        int i = (int)a;
        return (float)i > a ? i - 1 : i;
    }

    public static long getRounded(double a) {
        return Math.round(a);
    }

    public static int getRounded(float a) {
        return Math.round(a);
    }

    public static double raiseToPower(double value, double power) {
        return Math.pow(value, power);
    }

    public static double roundTo(double value, int fractDigits) {
        double raise = CommonMath.raiseToPower(10.0, fractDigits);
        double mult = value * raise;
        long round = CommonMath.getRounded(mult);
        return (double)round / raise;
    }

    public static double getMinByAbs(double a, double b) {
        if (Math.abs(a) <= Math.abs(b)) {
            return a;
        }
        return b;
    }

    public static double getMaxByAbs(double a, double b) {
        if (Math.abs(a) <= Math.abs(b)) {
            return a;
        }
        return b;
    }

    public static double getDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double getRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static float getMirrored(float value, FloatBounds bounds) {
        if (bounds != null) {
            return bounds.getMax().floatValue() - value + bounds.getMin().floatValue();
        }
        return value;
    }

    public static boolean sameSign(float value1, float value2) {
        return Math.signum(value1) == Math.signum(value2);
    }

    public static boolean sameSign(double value1, double value2) {
        return Math.signum(value1) == Math.signum(value2);
    }

    public static class Random
    extends java.util.Random {
        private static final long serialVersionUID = -5036832263594314436L;

        public static double around(double value, double maxDeviation) {
            return Random.between(value - maxDeviation, value + maxDeviation);
        }

        public static float around(float value, float maxDeviation) {
            return Random.between(value - maxDeviation, value + maxDeviation);
        }

        public static double between(double first, double second) {
            return Random.between(first, second, (java.util.Random)RANDOM);
        }

        public static double between(double first, double second, java.util.Random random) {
            if (random.nextDouble() == 0.0) {
                return second;
            }
            return random.nextDouble() * (second - first) + first;
        }

        public static float between(float first, float second) {
            return Random.between(first, second, (java.util.Random)RANDOM);
        }

        public static float between(float first, float second, java.util.Random random) {
            if (random.nextFloat() == 0.0f) {
                return second;
            }
            return random.nextFloat() * (second - first) + first;
        }

        public static int between(int first, int second) {
            return Random.between(first, second, (java.util.Random)RANDOM);
        }

        public static int between(int first, int second, java.util.Random random) {
            if (first < second) {
                return random.nextInt(second - first + 1) + first;
            }
            return random.nextInt(first - second + 1) + second;
        }

        @Nullable
        @Deprecated
        public static <T> T from(List<T> list) {
            return Random.from(list, (java.util.Random)RANDOM).orElse(null);
        }

        public static <T> Optional<T> from(List<T> list, java.util.Random random) {
            if (list != null && list.size() > 0) {
                int index = Random.between(0, list.size() - 1, random);
                return Optional.ofNullable(list.get(index));
            }
            return Optional.empty();
        }

        public static <T> Optional<T> from(T[] array, java.util.Random random) {
            if (array != null && array.length > 0) {
                int index = Random.between(0, array.length - 1, random);
                return Optional.of(array[index]);
            }
            return Optional.empty();
        }

        public static <E extends Enum<?>> Optional<E> from(Class<E> enumClass, java.util.Random random) {
            return Random.from((Enum[])enumClass.getEnumConstants(), random);
        }

        public static boolean result(float probability) {
            return Random.result(probability, RANDOM);
        }

        public static boolean result(float probability, java.util.Random random) {
            return random.nextFloat() < probability;
        }

        public static int sign() {
            return Random.sign(RANDOM);
        }

        public static int sign(java.util.Random random) {
            return Random.getBoolean(random) ? 1 : -1;
        }

        public static boolean getBoolean() {
            return Random.getBoolean(RANDOM);
        }

        public static boolean getBoolean(java.util.Random random) {
            return random.nextBoolean();
        }

        public static float getFloat() {
            return Random.getFloat(RANDOM);
        }

        public static float getFloat(java.util.Random random) {
            return random.nextFloat();
        }

        public static double getDouble() {
            return Random.getDouble(RANDOM);
        }

        public static double getDouble(java.util.Random random) {
            return random.nextDouble();
        }

        public static int getInt() {
            return Random.getInt(RANDOM);
        }

        public static int getInt(java.util.Random random) {
            return random.nextInt();
        }
    }

    public static class Range {
        public static double enclose(double value, double bound1, double bound2) {
            double min = Math.min(bound1, bound2);
            double max = Math.max(bound1, bound2);
            if (value < min) {
                value = min;
            }
            if (value > max) {
                value = max;
            }
            return value;
        }

        public static float enclose(float value, float bound1, float bound2) {
            float min = Math.min(bound1, bound2);
            float max = Math.max(bound1, bound2);
            if (value < min) {
                value = min;
            }
            if (value > max) {
                value = max;
            }
            return value;
        }

        public static int enclose(int value, int bound1, int bound2) {
            int min = Math.min(bound1, bound2);
            int max = Math.max(bound1, bound2);
            if (value < min) {
                value = min;
            }
            if (value > max) {
                value = max;
            }
            return value;
        }

        public static float enclose(float value, FloatBounds bounds) {
            if (bounds != null) {
                return Range.enclose(value, bounds.getMin().floatValue(), bounds.getMax().floatValue());
            }
            return value;
        }

        public static int enclose(int value, IntBounds bounds) {
            if (bounds != null) {
                return Range.enclose(value, bounds.getMin(), bounds.getMax());
            }
            return value;
        }
    }

    public static class Interpolation<T extends Number> {
        public final IBounds<T> source;
        public final IBounds<T> dest;

        public Interpolation(IBounds<T> source, IBounds<T> dest) {
            this.source = source;
            this.dest = dest;
        }

        public T straight(T value) {
            float factor = this.source.interpolationFactor(value);
            return this.dest.interpolateUp(factor);
        }

        public T backward(T value) {
            float factor = this.source.interpolationFactor(value);
            return this.dest.interpolateDown(factor);
        }

        public static float straight(float factor, float begin, float end) {
            return begin + (end - begin) * factor;
        }

        public static float backward(float factor, float begin, float end) {
            return end - (end - begin) * factor;
        }

        public static float up(float factor, FloatBounds bounds) {
            return Interpolation.straight(factor, bounds.getMin().floatValue(), bounds.getMax().floatValue());
        }

        public static float down(float factor, FloatBounds bounds) {
            return Interpolation.backward(factor, bounds.getMin().floatValue(), bounds.getMax().floatValue());
        }

        public static int up(float factor, IntBounds bounds) {
            return CommonMath.getRounded(Interpolation.straight(factor, bounds.getMin().intValue(), bounds.getMax().intValue()));
        }

        public static int down(float factor, IntBounds bounds) {
            return CommonMath.getRounded(Interpolation.backward(factor, bounds.getMin().intValue(), bounds.getMax().intValue()));
        }

        public static float strictUp(float factor, FloatBounds bounds) {
            return Range.enclose(Interpolation.up(factor, bounds), bounds);
        }

        public static int strictUp(float factor, IntBounds bounds) {
            return Range.enclose(Interpolation.up(factor, bounds), bounds);
        }

        public static float strictDown(float factor, FloatBounds bounds) {
            return Range.enclose(Interpolation.down(factor, bounds), bounds);
        }

        public static int strictDown(float factor, IntBounds bounds) {
            return Range.enclose(Interpolation.down(factor, bounds), bounds);
        }
    }

    public static class Angle {
        public static final Angle ZERO = Angle.fromRadians(0.0);
        protected static final double HALF_REVOLUTION = Math.PI;
        protected static final double FULL_REVOLUTION = Math.PI * 2;
        private final double radians;

        protected Angle(double radians) {
            this.radians = radians;
        }

        public static Angle fromDegrees(double degrees) {
            return Angle.fromRadians(degrees * Math.PI / 180.0);
        }

        public static Angle fromRadians(double radians) {
            return new Angle(radians % (Math.PI * 2));
        }

        public static Angle fromCos(double cos) {
            return Angle.fromRadians(Math.acos(cos));
        }

        public static Angle fromSin(double sin) {
            return Angle.fromRadians(Math.asin(sin));
        }

        public static Angle fromTan(double tan) {
            return Angle.fromRadians(Math.atan(tan));
        }

        public static Angle random() {
            return Angle.fromRadians(Random.between(0.0, Math.PI * 2));
        }

        public double getRadians() {
            return this.radians;
        }

        public double getDegrees() {
            return this.getRadians() * 180.0 / Math.PI;
        }

        public Angle add(Angle angle) {
            return Angle.fromRadians(this.getRadians() + angle.getRadians());
        }

        public Angle substract(Angle angle) {
            return Angle.fromRadians(this.getRadians() - angle.getRadians());
        }

        public Angle negative() {
            return Angle.fromRadians(-this.getRadians());
        }

        public double cos() {
            return Math.cos(this.getRadians());
        }

        public double sin() {
            return Math.sin(this.getRadians());
        }

        public double tan() {
            return Math.tan(this.getRadians());
        }
    }
}

