/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class RelatedBlock
extends ForgeBlock
implements IRelatedUnit {
    private final UnitId relatedBlockId;

    public RelatedBlock(UnitConfig config, Properties<?> props) {
        super(config, props.vanillaProps);
        this.relatedBlockId = props.id;
    }

    @Override
    public UnitId getRelatedId() {
        return this.relatedBlockId;
    }

    @Nullable
    public BlockState getRelatedState() {
        return this.getRelatedId() != null ? this.getRelatedId().getFirstMatchedState() : null;
    }

    public boolean exists() {
        return this.getRelatedState() != null;
    }

    public SoundType m_49962_(BlockState state) {
        return this.getRelatedState() != null ? this.getRelatedState().m_60827_() : super.m_49962_(state);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return this.getRelatedState() != null ? this.getRelatedState().getSoundType(world, pos, entity) : super.getSoundType(state, world, pos, entity);
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public final String name;
        public BlockBehaviour.Properties vanillaProps;

        protected Properties(Class<T> selfClass, String name, UnitId relatedBlockId) {
            super(selfClass);
            this.name = name;
            this.id = relatedBlockId;
            this.vanillaProps = relatedBlockId.getBlockProperties();
        }

        public static Properties<?> of(String name, UnitId relatedBlockId) {
            return new Properties<Properties>(Properties.class, name, relatedBlockId);
        }
    }
}

