/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Tooltip {
    private final ResourceLocation location;
    private final List<Component> lines;

    public Tooltip(ResourceLocation location, List<Component> lines) {
        this.location = location;
        this.lines = lines;
    }

    public static Tooltip of(AbstractForgeMod mod, String name, List<Component> lines) {
        return new Tooltip(mod.getNamespace().location(name), lines);
    }

    protected String expandLangKey(String langKey) {
        return Names.dotted().join("tooltip", this.location.m_135827_(), this.location.m_135815_(), langKey);
    }

    public Tooltip add(ChatFormatting textFormat, String langKey) {
        return this.add(textFormat, langKey, null);
    }

    public Tooltip add(ChatFormatting textFormat, String langKey, @Nullable Object value) {
        String key = this.expandLangKey(langKey);
        Object postfix = value != null ? ": " + value : "";
        this.lines.add((Component)Component.m_237113_((String)(textFormat + I18n.m_118938_((String)key, (Object[])new Object[0]) + (String)postfix)));
        return this;
    }

    public Tooltip add(String langKey, Object ... parameters) {
        this.lines.add((Component)Component.m_237113_((String)I18n.m_118938_((String)this.expandLangKey(langKey), (Object[])parameters)));
        return this;
    }

    public Tooltip addEmptyLine() {
        return this.addRaw("");
    }

    public Tooltip holdShiftForDetails() {
        return this.add("details", ChatFormatting.GRAY, ChatFormatting.DARK_PURPLE, InputConstants.m_84851_((String)"key.keyboard.left.shift").m_84875_().getString());
    }

    public boolean showDetails() {
        return Screen.m_96638_();
    }

    public Tooltip addRaw(String string) {
        this.lines.add((Component)Component.m_237113_((String)string));
        return this;
    }

    public String button(String langKey, KeyMapping button) {
        String action = langKey.isEmpty() ? "" : I18n.m_118938_((String)this.expandLangKey(langKey), (Object[])new Object[0]) + " ";
        return action + button.m_90863_().getString();
    }
}

