/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGroupMap<G, K, V> {
    protected final Map<G, Map<K, V>> map = new ConcurrentHashMap<G, Map<K, V>>();

    @Nonnull
    protected abstract G getGroup(K var1);

    @Nullable
    protected V getValue(K key) {
        G group = this.getGroup(key);
        Map<K, V> values = this.map.get(group);
        if (values != null) {
            return values.get(key);
        }
        return null;
    }

    protected V put(K key, V value) {
        G group = this.getGroup(key);
        Map<K, V> inner = this.map.get(group);
        if (inner == null) {
            inner = new ConcurrentHashMap();
        }
        return inner.put(key, value);
    }
}

