/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.UnitProperties;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeItem
extends Item
implements IHaveConfig {
    private final UnitConfig config;

    public ForgeItem(UnitConfig config, Properties<?> properties) {
        super(properties.vanillaProps);
        this.config = config;
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static <T extends LivingEntity> void damageItem(int damage, ItemStack stack, boolean destroyBroken, @Nullable T damager, @Nullable Consumer<T> onBroken) {
        ServerPlayer player;
        ServerPlayer serverPlayer = player = damager instanceof ServerPlayer ? (ServerPlayer)damager : null;
        if (player == null || player.m_7500_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof DamageableItem) {
            ((DamageableItem)item).updateDurability(stack, player);
        }
        if (stack != null && stack.m_41763_()) {
            if (stack.m_220157_(damage, player.m_217043_(), player)) {
                stack.m_41721_(stack.m_41776_());
            }
            if (ForgeItem.isBroken(stack)) {
                if (damager != null && onBroken != null) {
                    onBroken.accept(damager);
                }
                if (destroyBroken) {
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                }
                if (player != null) {
                    player.m_36246_(Stats.f_12983_.m_12902_((Object)item));
                }
            }
        }
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41763_() && stack.m_41773_() >= stack.m_41776_();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    public static Optional<Integer> indexIn(Inventory inventory, Predicate<ItemStack> predicate) {
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(inventory.m_8020_(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final Item.Properties vanillaProps = new Item.Properties();

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }
    }
}

