/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonMath;
import com.endertech.common.Ordered;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.world.level.material.MapColor;

public class Percentage
implements Ordered<Percentage> {
    public static final float FACTOR = 100.0f;
    public static final Percentage ZERO = new Percentage(0.0f);
    public static final Percentage HUNDRED = new Percentage(100.0f);
    private final float value;

    public Percentage(float value) {
        this.value = value;
    }

    public static Percentage value(float value) {
        return new Percentage(value);
    }

    public static Percentage from(int value, int maxValue) {
        return CommonMath.isAlmostZero(maxValue) ? ZERO : Percentage.from((float)value / (float)maxValue);
    }

    public static Percentage from(float rate) {
        return new Percentage(rate * 100.0f);
    }

    public static Percentage parse(String string) throws NumberFormatException {
        float value = Float.parseFloat(string.replace('%', ' ').trim());
        return new Percentage(value);
    }

    public float getValue() {
        return this.value;
    }

    public Grade getGrade() {
        Grade[] grades = Grade.values();
        for (int i = grades.length - 1; i >= 0; --i) {
            if (!(this.getValue() > grades[i].threshold)) continue;
            return grades[i];
        }
        return Grade.LOW;
    }

    public boolean takeChance() {
        return this.takeChance(CommonMath.RANDOM);
    }

    public boolean takeChance(Random random) {
        return this.toFraction() > random.nextFloat();
    }

    public float toFraction() {
        return this.getValue() / 100.0f;
    }

    public Percentage multiply(float value) {
        return Percentage.value(this.getValue() * value);
    }

    public String toString() {
        return String.format("%.0f%%", Float.valueOf(this.getValue()));
    }

    public String toColoredText() {
        return this.getGrade().textColor + this.toString();
    }

    public boolean randomResult() {
        return CommonMath.Random.result(this.toFraction());
    }

    @Override
    public int compareTo(Percentage other) {
        return Float.compare(this.getValue(), other.getValue());
    }

    public boolean equals(Object obj) {
        return obj instanceof Percentage && ((Percentage)obj).getValue() == this.getValue();
    }

    public int hashCode() {
        return Float.hashCode(this.getValue());
    }

    public static enum Grade {
        LOW(0.0f, ChatFormatting.GREEN, MapColor.f_283784_),
        MEDIUM(40.0f, ChatFormatting.YELLOW, MapColor.f_283832_),
        HIGH(70.0f, ChatFormatting.RED, MapColor.f_283913_);

        public final float threshold;
        public final ChatFormatting textColor;
        public final MapColor mapColor;

        private Grade(float threshold, ChatFormatting textColor, MapColor mapColor) {
            this.threshold = threshold;
            this.textColor = textColor;
            this.mapColor = mapColor;
        }
    }
}

