/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class HorizSpread {
    private final Level world;
    private final BlockPos centerPos;
    private final Predicate<BlockState> canPassThrough;
    private final int radius;
    private final boolean[][] checkedMatrix;
    private final int centerIndex;
    private final Predicate<BlockState> matchedState;
    private final IntBounds indexRange;

    protected HorizSpread(Level world, BlockPos centerPos, int radius, Predicate<BlockState> canSpreadThrough, Predicate<BlockState> matchedState) {
        this.world = world;
        this.centerPos = centerPos;
        this.radius = radius;
        this.canPassThrough = canSpreadThrough;
        this.matchedState = matchedState;
        int matrixSize = this.radius * 2 + 1;
        this.checkedMatrix = new boolean[matrixSize][matrixSize];
        this.centerIndex = radius;
        this.indexRange = new IntBounds(0, matrixSize - 1);
    }

    protected boolean isInRange(BlockPos pos) {
        Vec3i matrixPos = this.getMatrixPos(pos);
        return this.indexRange.encloses(matrixPos.m_123341_()) && this.indexRange.encloses(matrixPos.m_123342_()) && this.indexRange.encloses(matrixPos.m_123343_());
    }

    protected boolean isChecked(BlockPos pos) {
        Vec3i matrixPos = this.getMatrixPos(pos);
        return this.checkedMatrix[matrixPos.m_123341_()][matrixPos.m_123343_()];
    }

    protected void setChecked(BlockPos pos) {
        Vec3i matrixPos = this.getMatrixPos(pos);
        this.checkedMatrix[matrixPos.m_123341_()][matrixPos.m_123343_()] = true;
    }

    protected Vec3i getMatrixPos(BlockPos pos) {
        return pos.m_121996_((Vec3i)this.centerPos).m_7918_(this.centerIndex, this.centerIndex, this.centerIndex);
    }

    @Nullable
    protected BlockPos findMatchedPos(BlockPos pos) {
        if (!this.isInRange(pos) || this.isChecked(pos)) {
            return null;
        }
        BlockState state = this.world.m_8055_(pos);
        if (this.matchedState.test(state)) {
            return pos;
        }
        this.setChecked(pos);
        if (this.canPassThrough.test(state)) {
            for (Direction direction : GameWorld.Directions.of().horizontals().shuffle().toArray()) {
                BlockPos foundPos = this.findMatchedPos(pos.m_121945_(direction));
                if (foundPos == null) continue;
                return foundPos;
            }
        }
        return null;
    }

    @Nullable
    public static BlockPos findAirPos(Level world, BlockPos centerPos, int radius, Predicate<BlockState> canSpreadThrough) {
        return HorizSpread.findMatchedPos(world, centerPos, radius, canSpreadThrough, BlockBehaviour.BlockStateBase::m_60795_);
    }

    @Nullable
    public static BlockPos findMatchedPos(Level world, BlockPos centerPos, int radius, Predicate<BlockState> canSpreadThrough, Predicate<BlockState> matchedState) {
        BlockState state = world.m_8055_(centerPos);
        if (matchedState.test(state)) {
            return centerPos;
        }
        if (canSpreadThrough.test(state)) {
            HorizSpread spread = new HorizSpread(world, centerPos, radius, canSpreadThrough, matchedState);
            return spread.findMatchedPos(centerPos);
        }
        return null;
    }
}

