function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/kinetics/base/BlockBreakingKineticBlockEntity',
		'methodName' : 'onBlockBroken', 
		'methodDesc' : '(Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var node = {
		'class' : 'com/simibubi/create/foundation/utility/BlockHelper',
		'methodName' : 'destroyBlock',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLjava/util/function/Consumer;)V'
	}

    var level = {
		'class' : 'com/simibubi/create/content/kinetics/base/BlockBreakingKineticBlockEntity',
		'fieldName' : resolveName('f_58857_'), // level
		'fieldDesc' : 'Lnet/minecraft/world/level/Level;'
	}

    var pos = {
		'class' : 'com/simibubi/create/content/kinetics/base/BlockBreakingKineticBlockEntity',
		'fieldName' : 'breakingPos',
		'fieldDesc' : 'Lnet/minecraft/core/BlockPos;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onBlockBroken',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var instructions = [
	    insnLoadThis("KineticTile"),
		insnGetField(level),
		insnLoadThis("KineticTile"),
		insnGetField(pos),
		insnLoadObj(1, "state"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}