function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/fluids/FluidReactions',
		'methodName' : 'handlePipeSpillCollision',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;Lnet/minecraft/world/level/material/FluidState;)V'
	}

	var node = {
		'class' : 'net/minecraftforge/eventbus/api/IEventBus',
		'methodName' : 'post',
		'methodDesc' : '(Lnet/minecraftforge/eventbus/api/Event;)Z'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Create',
		'methodName' : 'handleFluidCollision',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;Lnet/minecraft/world/level/material/Fluid;)V'
	}

	var instructions = [
		insnLoadObj(0, "level"),
		insnLoadObj(1, "pos"),
		insnLoadObj(4, "pipeFluid"),
		insnLoadObj(5, "worldFluid"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}