function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'cam72cam/immersiverailroading/entity/LocomotiveSteam',
		'methodName' : 'onTick',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'cam72cam/mod/item/ItemStack',
		'methodName' : 'setCount',
		'methodDesc' : '(I)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/entity/Entity;Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;)V'
	}

	var internalStack = {
		'class' : 'cam72cam/mod/item/ItemStack',
		'methodName' : 'internal',
		'methodDesc' : '()Lnet/minecraft/world/item/ItemStack;'
	}

	var internalEntity = {
		'class' : 'cam72cam/mod/entity/CustomEntity',
		'fieldName' : 'internal',
		'fieldDesc' : 'Lcam72cam/mod/entity/ModdedEntity;'
	}

	var alignment = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName' : 'CENTER',
		'fieldDesc' : 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [
		insnInvokeVirtual(internalStack),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("steam locomotive"),
		insnGetField(internalEntity),
		insnGetStatic(alignment), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("fuel itemstack"), instructions));
				return method;
			}
		}
	}
}