function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/entity/projectile/FireworkRocketEntity',
		'methodName' : resolveName('m_37080_'), // explode
		'methodDesc' : '()V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Minecraft',
		'methodName' : 'handleFireworkExplosion',
		'methodDesc' : '(Lnet/minecraft/world/entity/projectile/FireworkRocketEntity;)V'
	}

	var instructions = [ 
		insnLoadThis("firework rocket entity"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}