function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'com/mrcrayfish/vehicle/entity/PoweredVehicleEntity',
		'methodName': 'onUpdateVehicle',
		'methodDesc': '()V'
	}

	var node = {
		'class': 'com/mrcrayfish/vehicle/entity/PoweredVehicleEntity',
		'methodName': 'setCurrentEnergy',
		'methodDesc': '(F)V'
	}

	var getCurrentFuel = {
		'class': 'com/mrcrayfish/vehicle/entity/PoweredVehicleEntity',
		'methodName': 'getCurrentEnergy',
		'methodDesc': '()F'
	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/MrCrayfish$PoweredVehicle',
		'methodName': 'onFuelBurned',
		'methodDesc': '(FFLnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
		insnDup("new fuel amount"),
		insnLoadThis("vehicle"),
		insnInvokeVirtual(getCurrentFuel),
		insnLoadThis("vehicle"),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}