/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.block.entity;

import java.util.Optional;
import net.diverginglensestudios.undeadremains.block.entity.ModBlockEntities;
import net.diverginglensestudios.undeadremains.recipe.GemPolishingRecipe;
import net.diverginglensestudios.undeadremains.screen.FossilPolishingStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FossilPolishingStationBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            FossilPolishingStationBlockEntity.this.m_6596_();
            if (!FossilPolishingStationBlockEntity.this.f_58857_.m_5776_()) {
                FossilPolishingStationBlockEntity.this.f_58857_.m_7260_(FossilPolishingStationBlockEntity.this.m_58899_(), FossilPolishingStationBlockEntity.this.m_58900_(), FossilPolishingStationBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> FossilPolishingStationBlockEntity.this.progress;
                case 1 -> FossilPolishingStationBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    FossilPolishingStationBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    FossilPolishingStationBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 78;

    public FossilPolishingStationBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FOSSIL_POLISHING_BE.get(), pPos, pBlockState);
    }

    public ItemStack getRenderStack() {
        if (this.itemHandler.getStackInSlot(1).m_41619_()) {
            return this.itemHandler.getStackInSlot(0);
        }
        return this.itemHandler.getStackInSlot(1);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.undeadremains.gem_polishing_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FossilPolishingStationMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("gem_polishing_station.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("gem_polishing_station.progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            FossilPolishingStationBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<GemPolishingRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(1).m_41613_() + result.m_41613_()));
    }

    private boolean hasRecipe() {
        Optional<GemPolishingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<GemPolishingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)GemPolishingRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

