/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.block.entity;

import net.diverginglensestudios.undeadremains.block.entity.ModBlockEntities;
import net.diverginglensestudios.undeadremains.item.ModItems;
import net.diverginglensestudios.undeadremains.screen.XanarianGatewayMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XanarianGatewayBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            XanarianGatewayBlockEntity.this.m_6596_();
            if (!XanarianGatewayBlockEntity.this.f_58857_.m_5776_()) {
                XanarianGatewayBlockEntity.this.f_58857_.m_7260_(XanarianGatewayBlockEntity.this.m_58899_(), XanarianGatewayBlockEntity.this.m_58900_(), XanarianGatewayBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> XanarianGatewayBlockEntity.this.progress;
                case 1 -> XanarianGatewayBlockEntity.this.maxProgress;
                case 2 -> XanarianGatewayBlockEntity.this.charge;
                case 3 -> XanarianGatewayBlockEntity.this.maxCharge;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    XanarianGatewayBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    XanarianGatewayBlockEntity.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    XanarianGatewayBlockEntity.this.charge = pValue;
                    break;
                }
                case 3: {
                    XanarianGatewayBlockEntity.this.maxCharge = pValue;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 78;
    private int charge = 0;
    private int maxCharge = 4;

    public XanarianGatewayBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.XANARIAN_GATEWAY_BE.get(), pPos, pBlockState);
    }

    public ItemStack getRenderStack() {
        if (this.itemHandler.getStackInSlot(1).m_41619_()) {
            return this.itemHandler.getStackInSlot(0);
        }
        return this.itemHandler.getStackInSlot(1);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.undeadremains.xanarian_gateway");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new XanarianGatewayMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("xanarian_gateway.progress", this.progress);
        pTag.m_128405_("xanarian_gateway.charge", this.charge);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("xanarian_gateway.progress");
        this.charge = pTag.m_128451_("xanarian_gateway.charge");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            XanarianGatewayBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        ItemStack result = new ItemStack((ItemLike)ModItems.EMPTY_FUEL_CELL.get(), 1);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(1).m_41613_() + result.m_41613_()));
        ++this.charge;
        System.out.println("current charge is " + this.charge);
    }

    private boolean hasRecipe() {
        boolean hasCraftingItem = this.itemHandler.getStackInSlot(0).m_41720_() == ModItems.METATURBONITE.get();
        ItemStack result = new ItemStack((ItemLike)ModItems.EMPTY_FUEL_CELL.get());
        return hasCraftingItem && this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_()) && this.charge < 4;
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean canTeleport() {
        return this.charge > 0;
    }

    public void consumeCharge() {
        if (this.charge > 0) {
            --this.charge;
            this.m_6596_();
        }
    }
}

