/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.datagen;

import java.util.LinkedHashMap;
import net.diverginglensestudios.undeadremains.block.ModBlocks;
import net.diverginglensestudios.undeadremains.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "undeadremains", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.FOSSIL);
        this.simpleItem(ModItems.RARE_FOSSIL);
        this.simpleItem(ModItems.RAW_DEEPSLATE_FOSSIL);
        this.simpleItem(ModItems.RAW_FOSSIL);
        this.simpleItem(ModItems.RAW_LANGRITE);
        this.simpleItem(ModItems.LANGRITE_INGOT);
        this.simpleItem(ModItems.METATURBONITE);
        this.simpleItem(ModItems.EMPTY_FUEL_CELL);
        this.simpleItem(ModItems.XANARIAN_SPINE);
        this.simpleItem(ModItems.XANARIAN_HORN);
        this.simpleItem(ModItems.XANARIAN_LEATHER);
        this.simpleItem(ModItems.METATORBERNITE);
        this.simpleItem(ModItems.SUNGLASSES);
        this.simpleItem(ModItems.SPIKE);
        this.simpleItem(ModItems.ASH_SIGN);
        this.simpleItem(ModItems.ASH_HANGING_SIGN);
        this.simpleItem(ModItems.CALIPO_SIGN);
        this.simpleItem(ModItems.CALIPO_HANGING_SIGN);
        this.simpleItem(ModItems.ASH_BOAT);
        this.simpleItem(ModItems.ASH_CHEST_BOAT);
        this.simpleItem(ModItems.METATORBERNITE_GRENADE);
        this.simpleItem(ModItems.FOSSILIZED_DRUMSTICK);
        this.simpleItem(ModItems.GOLD_BLOCK_MODIFIED_FOSSILIZED_DRUMSTICK);
        this.simpleItem(ModItems.THE_FOSSILS_EYE);
        this.simpleItem(ModItems.THE_QUARTZ_MODIFIED_FOSSILS_EYE);
        this.simpleItem(ModItems.RAW_XANARIAN_MEAT);
        this.simpleItem(ModItems.XANARIAN_MEAT);
        this.simpleItem(ModItems.XANARIAN_KEBAB);
        this.simpleItem(ModItems.XANARIAN_SHISH_KEBAB);
        this.simpleItem(ModItems.XANARIAN_KEBAB_WRAP);
        this.simpleItem(ModItems.WRAP);
        this.simpleItem(ModItems.CALIPO_BERRIES);
        this.simpleItem(ModItems.XANS_LEAF);
        this.simpleItem(ModItems.XANS_LEAF_SEEDS);
        this.saplingItem(ModBlocks.ASH_SAPLING);
        this.saplingItem(ModBlocks.CALIPO_SAPLING);
        this.simpleItem(ModItems.UNDYING_WHISPERS_MUSIC_DISC);
        this.simpleBlockItem(ModBlocks.FOSSIL_DOOR);
        this.simpleBlockItem(ModBlocks.ASH_DOOR);
        this.simpleBlockItem(ModBlocks.CALIPO_DOOR);
        this.fenceItem(ModBlocks.FOSSIL_FENCE, ModBlocks.FOSSIL_BLOCK);
        this.fenceItem(ModBlocks.ASH_FENCE, ModBlocks.ASH_PLANKS);
        this.fenceItem(ModBlocks.CALIPO_FENCE, ModBlocks.CALIPO_PLANKS);
        this.buttonItem(ModBlocks.FOSSIL_BUTTON, ModBlocks.FOSSIL_BLOCK);
        this.buttonItem(ModBlocks.ASH_BUTTON, ModBlocks.ASH_PLANKS);
        this.buttonItem(ModBlocks.CALIPO_BUTTON, ModBlocks.CALIPO_PLANKS);
        this.wallItem(ModBlocks.FOSSIL_WALL, ModBlocks.FOSSIL_BLOCK);
        this.wallItem(ModBlocks.LANGSTONE_WALL, ModBlocks.LANGSTONE);
        this.wallItem(ModBlocks.POLISHED_LANGSTONE_WALL, ModBlocks.POLISHED_LANGSTONE);
        this.wallItem(ModBlocks.LANGSTONE_BRICK_WALL, ModBlocks.LANGSTONE_BRICKS);
        this.wallItem(ModBlocks.DEEP_LANGSTONE_WALL, ModBlocks.DEEP_LANGSTONE);
        this.wallItem(ModBlocks.DEEP_LANGSTONE_BRICK_WALL, ModBlocks.DEEP_LANGSTONE_BRICKS);
        this.wallItem(ModBlocks.POLISHED_DEEP_LANGSTONE_WALL, ModBlocks.POLISHED_DEEP_LANGSTONE);
        this.evenSimplerBlockItem(ModBlocks.FOSSIL_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.METATORBERNITE_ENRICHER_CONTROLLER);
        this.evenSimplerBlockItem(ModBlocks.METATORBERNITE_ENRICHER_PART);
        this.evenSimplerBlockItem(ModBlocks.FOSSIL_SLAB);
        this.evenSimplerBlockItem(ModBlocks.FOSSIL_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.FOSSIL_FENCE_GATE);
        this.evenSimplerBlockItem(ModBlocks.ASH_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.ASH_SLAB);
        this.evenSimplerBlockItem(ModBlocks.ASH_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.ASH_FENCE_GATE);
        this.evenSimplerBlockItem(ModBlocks.CALIPO_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CALIPO_SLAB);
        this.evenSimplerBlockItem(ModBlocks.CALIPO_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.CALIPO_FENCE_GATE);
        this.evenSimplerBlockItem(ModBlocks.LANGSTONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.LANGSTONE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_LANGSTONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_LANGSTONE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.LANGSTONE_BRICK_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.LANGSTONE_BRICK_SLAB);
        this.evenSimplerBlockItem(ModBlocks.DEEP_LANGSTONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.DEEP_LANGSTONE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.DEEP_LANGSTONE_BRICK_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.DEEP_LANGSTONE_BRICK_SLAB);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_DEEP_LANGSTONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_DEEP_LANGSTONE_SLAB);
        this.trapdoorItem(ModBlocks.FOSSIL_TRAPDOOR);
        this.trapdoorItem(ModBlocks.ASH_TRAPDOOR);
        this.trapdoorItem(ModBlocks.CALIPO_TRAPDOOR);
        this.handheldItem(ModItems.FOSSIL_SWORD);
        this.handheldItem(ModItems.AMETHYST_MODIFIED_FOSSIL_SWORD);
        this.handheldItem(ModItems.FOSSIL_PICKAXE);
        this.handheldItem(ModItems.BLAZE_ROD_MODIFIED_FOSSIL_PICKAXE);
        this.handheldItem(ModItems.FOSSIL_AXE);
        this.handheldItem(ModItems.RABBIT_FOOT_MODIFIED_FOSSIL_AXE);
        this.handheldItem(ModItems.FOSSIL_SHOVEL);
        this.handheldItem(ModItems.NAUTILUS_SHELL_MODIFIED_FOSSIL_SHOVEL);
        this.handheldItem(ModItems.FOSSIL_HOE);
        this.handheldItem(ModItems.SLIME_BALL_MODIFIED_FOSSIL_HOE);
        this.handheldItem(ModItems.LANGRITE_SWORD);
        this.handheldItem(ModItems.LANGRITE_PICKAXE);
        this.handheldItem(ModItems.LANGRITE_AXE);
        this.handheldItem(ModItems.LANGRITE_SHOVEL);
        this.handheldItem(ModItems.LANGRITE_HOE);
        this.handheldItem(ModItems.METATORBERNITE_SWORDAXE);
        this.handheldItem(ModItems.METATORBERNITE_PICKAXE);
        this.handheldItem(ModItems.METATORBERNITE_SHOVEL);
        this.handheldItem(ModItems.METATORBERNITE_HOE);
        this.handheldItem(ModItems.METATORBERNITE_TOOL);
        this.handheldItem(ModItems.RARE_FOSSIL_SWORD);
        this.handheldItem(ModItems.RARE_FOSSIL_PICKAXE);
        this.handheldItem(ModItems.RARE_FOSSIL_AXE);
        this.handheldItem(ModItems.RARE_FOSSIL_SHOVEL);
        this.handheldItem(ModItems.RARE_FOSSIL_HOE);
        this.trimmedArmorItem(ModItems.GAS_MASK);
        this.trimmedArmorItem(ModItems.XANARIAN_SPINE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.METATORBERNITE_GAS_MASK);
        this.trimmedArmorItem(ModItems.FOSSIL_HELMET);
        this.trimmedArmorItem(ModItems.FOSSIL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.FOSSIL_LEGGINGS);
        this.trimmedArmorItem(ModItems.LIGHTNING_ROD_MODIFIED_FOSSIL_HELMET);
        this.trimmedArmorItem(ModItems.CLOCK_MODIFIED_FOSSIL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.SCUTE_MODIFIED_FOSSIL_LEGGINGS);
        this.trimmedArmorItem(ModItems.SCULK_SHARD_MODIFIED_FOSSIL_BOOTS);
        this.trimmedArmorItem(ModItems.FOSSIL_BOOTS);
        this.trimmedArmorItem(ModItems.RARE_FOSSIL_HELMET);
        this.trimmedArmorItem(ModItems.RARE_FOSSIL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.RARE_FOSSIL_LEGGINGS);
        this.trimmedArmorItem(ModItems.RARE_FOSSIL_BOOTS);
        this.trimmedArmorItem(ModItems.LANGRITE_HELMET);
        this.trimmedArmorItem(ModItems.LANGRITE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.LANGRITE_LEGGINGS);
        this.trimmedArmorItem(ModItems.LANGRITE_BOOTS);
        this.trimmedArmorItem(ModItems.METATORBERNITE_HELMET);
        this.trimmedArmorItem(ModItems.METATORBERNITE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.METATORBERNITE_LEGGINGS);
        this.trimmedArmorItem(ModItems.METATORBERNITE_BOOTS);
        this.trimmedArmorItem(ModItems.COW_HELMET);
        this.trimmedArmorItem(ModItems.COW_CHESTPLATE);
        this.trimmedArmorItem(ModItems.COW_LEGGINGS);
        this.trimmedArmorItem(ModItems.COW_BOOTS);
        this.withExistingParent(ModItems.UNDEADARCHEOLOGIST_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.FOSSILIZED_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.TREE_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SUPREME_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.COW_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SPIKE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.HAMMER_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.FOUR_EYED_XANARIAN_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.XANARIAN_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.HORNED_XANARIAN_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SUPREME_KNIGHT_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SMALL_WOODLING_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.BIG_WOODLING_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.STRAY_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.XANARIAN_CANNIBAL_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "undeadremains";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("undeadremains", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("undeadremains", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("undeadremains", "item/" + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    private ItemModelBuilder saplingItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("undeadremains", "block/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("undeadremains", "item/" + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("undeadremains:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("undeadremains", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("undeadremains", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("undeadremains", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("undeadremains", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("undeadremains", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("undeadremains", "block/" + item.getId().m_135815_()));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

