/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.entity.ai;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class ModMoveThroughVillageGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double speedModifier;
    @Nullable
    private Path path;
    private BlockPos poiPos;
    private final boolean onlyAtNight;
    private final List<BlockPos> visited = Lists.newArrayList();
    private final int distanceToPoi;
    private final Boolean canDealWithDoors;

    public ModMoveThroughVillageGoal(PathfinderMob pMob, double pSpeedModifier, boolean pOnlyAtNight, int pDistanceToPoi, Boolean pCanDealWithDoors) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.onlyAtNight = pOnlyAtNight;
        this.distanceToPoi = pDistanceToPoi;
        this.canDealWithDoors = pCanDealWithDoors;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        if (!GoalUtils.m_26894_((Mob)pMob)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    public boolean m_8036_() {
        BlockPos blockpos;
        if (!GoalUtils.m_26894_((Mob)this.mob)) {
            return false;
        }
        this.updateVisited();
        if (this.onlyAtNight && this.mob.m_9236_().m_46461_()) {
            return false;
        }
        ServerLevel serverlevel = (ServerLevel)this.mob.m_9236_();
        if (!serverlevel.m_8736_(blockpos = this.mob.m_20183_(), 6)) {
            return false;
        }
        Vec3 vec3 = LandRandomPos.m_148503_((PathfinderMob)this.mob, (int)15, (int)7, p_217751_ -> {
            if (!serverlevel.m_8802_(p_217751_)) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional optional1 = serverlevel.m_8904_().m_27186_(p_217758_ -> p_217758_.m_203656_(PoiTypeTags.f_215876_), this::hasNotVisited, p_217751_, 10, PoiManager.Occupancy.IS_OCCUPIED);
            return optional1.map(p_217754_ -> -p_217754_.m_123331_((Vec3i)blockpos)).orElse(Double.NEGATIVE_INFINITY);
        });
        if (vec3 == null) {
            return false;
        }
        Optional optional = serverlevel.m_8904_().m_27186_(p_217756_ -> p_217756_.m_203656_(PoiTypeTags.f_215876_), this::hasNotVisited, BlockPos.m_274446_((Position)vec3), 10, PoiManager.Occupancy.IS_OCCUPIED);
        if (optional.isEmpty()) {
            return false;
        }
        this.poiPos = ((BlockPos)optional.get()).m_7949_();
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.mob.m_21573_();
        boolean flag = groundpathnavigation.m_26492_();
        groundpathnavigation.m_26477_(this.canDealWithDoors.booleanValue());
        this.path = groundpathnavigation.m_7864_(this.poiPos, 0);
        groundpathnavigation.m_26477_(flag);
        if (this.path == null) {
            Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)this.poiPos), (double)1.5707963705062866);
            if (vec31 == null) {
                return false;
            }
            groundpathnavigation.m_26477_(this.canDealWithDoors.booleanValue());
            this.path = this.mob.m_21573_().m_26524_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 0);
            groundpathnavigation.m_26477_(flag);
            if (this.path == null) {
                return false;
            }
        }
        for (int i = 0; i < this.path.m_77398_(); ++i) {
            Node node = this.path.m_77375_(i);
            BlockPos blockpos1 = new BlockPos(node.f_77271_, node.f_77272_ + 1, node.f_77273_);
            if (!DoorBlock.m_52745_((Level)this.mob.m_9236_(), (BlockPos)blockpos1)) continue;
            this.path = this.mob.m_21573_().m_26524_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_, 0);
            break;
        }
        return this.path != null;
    }

    public boolean m_8045_() {
        if (this.mob.m_21573_().m_26571_()) {
            return false;
        }
        return !this.poiPos.m_203195_((Position)this.mob.m_20182_(), (double)(this.mob.m_20205_() + (float)this.distanceToPoi));
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
    }

    public void m_8041_() {
        if (this.mob.m_21573_().m_26571_() || this.poiPos.m_203195_((Position)this.mob.m_20182_(), (double)this.distanceToPoi)) {
            this.visited.add(this.poiPos);
        }
    }

    private boolean hasNotVisited(BlockPos p_25593_) {
        for (BlockPos blockpos : this.visited) {
            if (!Objects.equals(p_25593_, blockpos)) continue;
            return false;
        }
        return true;
    }

    private void updateVisited() {
        if (this.visited.size() > 15) {
            this.visited.remove(0);
        }
    }
}

