/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.entity.ai;

import net.diverginglensestudios.undeadremains.entity.custom.Zombies.UndeadArcheologistEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class UndeadArcheologistAttackGoal
extends MeleeAttackGoal {
    private final UndeadArcheologistEntity entity;
    private int attackDelay = 2;
    private int ticksUntilNextAttack = 8;
    private boolean shouldCountTillNextAttack = false;

    public UndeadArcheologistAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (UndeadArcheologistEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 2;
        this.ticksUntilNextAttack = 8;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.m_6639_(pEnemy);
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(11);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)pEnemy);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
    }
}

