/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.entity.custom.Zombies;

import net.diverginglensestudios.undeadremains.entity.ModEntities;
import net.diverginglensestudios.undeadremains.entity.ai.SpikeAttackGoal;
import net.diverginglensestudios.undeadremains.entity.custom.Zombies.ModAbstractZombie;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class SpikeEntity
extends ModAbstractZombie {
    private static final int THORNS_LEVEL = 2;
    private static final int THORNS_COOLDOWN_TICKS = 5;
    private long lastThornsTick = -1000L;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(SpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;

    public SpikeEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SpikeEntity(Level pLevel) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.SPIKE.get()), pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SpikeAttackGoal((PathfinderMob)this, 1.5, true));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker;
        boolean took = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && took && amount > 0.0f && (attacker = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            long now = this.m_9236_().m_46467_();
            if (now - this.lastThornsTick >= 5L) {
                int dmg = 1 + this.m_217043_().m_188503_(4);
                livingAttacker.m_6469_(this.m_9236_().m_269111_().m_269374_((Entity)this), (float)dmg);
                this.lastThornsTick = now;
                this.m_6677_(source);
            }
        }
        return took;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 3.0).m_22266_(Attributes.f_22287_);
    }
}

