/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.diverginglensestudios.undeadremains.effects.ModEffects;
import net.diverginglensestudios.undeadremains.entity.ModEntities;
import net.diverginglensestudios.undeadremains.entity.custom.Xanarians.AbstractXanarian;
import net.diverginglensestudios.undeadremains.entity.custom.Xanarians.XanarianCannibalEntity;
import net.diverginglensestudios.undeadremains.entity.custom.Zombies.BigWoodlingEntity;
import net.diverginglensestudios.undeadremains.entity.custom.Zombies.SmallWoodlingEntity;
import net.diverginglensestudios.undeadremains.entity.custom.Zombies.StrayZombieEntity;
import net.diverginglensestudios.undeadremains.entity.custom.Zombies.TreeZombieEntity;
import net.diverginglensestudios.undeadremains.item.ModItems;
import net.diverginglensestudios.undeadremains.playerData.xanarianreputation.PlayerXanarianReputation;
import net.diverginglensestudios.undeadremains.playerData.xanarianreputation.PlayerXanarianReputationProvider;
import net.diverginglensestudios.undeadremains.worldgen.dimension.ModDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="undeadremains")
public class ModEvents {
    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        Creeper creeper;
        LivingEntity entity = event.getEntity();
        if (entity instanceof TreeZombieEntity) {
            TreeZombieEntity treeZombie = (TreeZombieEntity)entity;
            Level level = treeZombie.m_9236_();
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BigWoodlingEntity bigWoodling = new BigWoodlingEntity((EntityType<? extends Monster>)((EntityType)ModEntities.BIG_WOODLING.get()), (Level)serverLevel);
                bigWoodling.m_7678_(treeZombie.m_20185_(), treeZombie.m_20186_(), treeZombie.m_20189_(), treeZombie.m_146908_(), 0.0f);
                serverLevel.m_7967_((Entity)bigWoodling);
                SmallWoodlingEntity smallWoodling = new SmallWoodlingEntity((EntityType<? extends Monster>)((EntityType)ModEntities.SMALL_WOODLING.get()), (Level)serverLevel);
                smallWoodling.m_7678_(treeZombie.m_20185_() + 0.5, treeZombie.m_20186_(), treeZombie.m_20189_() + 0.5, treeZombie.m_146908_(), 0.0f);
                serverLevel.m_7967_((Entity)smallWoodling);
            }
        } else if (entity instanceof Zombie && !(entity instanceof StrayZombieEntity)) {
            Level level = entity.m_9236_();
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState under = level.m_8055_(entity.m_20183_());
                if (under.m_60713_(Blocks.f_152499_)) {
                    StrayZombieEntity stray = new StrayZombieEntity((EntityType<? extends Monster>)((EntityType)ModEntities.STRAY_ZOMBIE.get()), (Level)serverLevel);
                    stray.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), 0.0f);
                    serverLevel.m_7967_((Entity)stray);
                }
            }
        } else if (entity instanceof AbstractXanarian) {
            DamageSource source = event.getSource();
            Entity entity2 = source.m_7639_();
            if (!(entity2 instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity2;
            player.getCapability(PlayerXanarianReputationProvider.PLAYER_XANARIAN_REPUTATION).ifPresent(rep -> rep.subXanarianReputation(player, 10));
        } else if (entity instanceof XanarianCannibalEntity) {
            DamageSource source = event.getSource();
            Entity entity3 = source.m_7639_();
            if (!(entity3 instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity3;
            player.getCapability(PlayerXanarianReputationProvider.PLAYER_XANARIAN_REPUTATION).ifPresent(rep -> rep.addXanarianReputation(player, 10));
        } else if (entity instanceof Creeper && (creeper = (Creeper)entity).m_9236_().m_46472_() == ModDimensions.FOSSILDIM_LEVEL_KEY) {
            DamageSource source = event.getSource();
            Entity entity4 = source.m_7639_();
            if (!(entity4 instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity4;
            player.getCapability(PlayerXanarianReputationProvider.PLAYER_XANARIAN_REPUTATION).ifPresent(rep -> rep.addXanarianReputation(player, 5));
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!event.getSource().m_276093_(DamageTypes.f_268671_)) {
            return;
        }
        LivingEntity living = event.getEntity();
        ItemStack chestplate = living.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_150930_((Item)ModItems.XANARIAN_SPINE_CHESTPLATE.get())) {
            event.setAmount(event.getAmount() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onTridentImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownTrident)) {
            return;
        }
        ThrownTrident trident = (ThrownTrident)projectile;
        if (!trident.m_150194_()) {
            return;
        }
        Entity owner = trident.m_19749_();
        if (!(owner instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer living = (ServerPlayer)owner;
        ItemStack helmet = living.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41720_() != ModItems.LIGHTNING_ROD_MODIFIED_FOSSIL_HELMET.get()) {
            return;
        }
        HitResult hit = event.getRayTraceResult();
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos strikePos = BlockPos.m_274446_((Position)hit.m_82450_());
        Level level = trident.m_9236_();
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        if (bolt == null) {
            return;
        }
        bolt.m_20219_(Vec3.m_82539_((Vec3i)strikePos));
        bolt.m_20879_(living);
        level.m_7967_((Entity)bolt);
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades;
        if (event.getType() == VillagerProfession.f_35590_) {
            trades = event.getTrades();
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)ModItems.THE_FOSSILS_EYE.get(), 12), 10, 8, 0.02f));
            ((List)trades.get(2)).add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)ModItems.FOSSILIZED_DRUMSTICK.get(), 6), 5, 9, 0.035f));
            ((List)trades.get(3)).add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42417_, 8), new ItemStack((ItemLike)ModItems.FOSSIL.get(), 2), 2, 12, 0.075f));
        }
        if (event.getType() == VillagerProfession.f_35594_) {
            trades = event.getTrades();
            ItemStack enchantedBook = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44972_, 2));
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 32), enchantedBook, 2, 8, 0.02f));
        }
    }

    @SubscribeEvent
    public static void addCustomWanderingTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ModItems.FOSSIL_BOOTS.get(), 1), 3, 2, 0.2f));
        rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 24), new ItemStack((ItemLike)ModItems.FOSSILIZED_DRUMSTICK.get(), 1), 2, 12, 0.15f));
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)ModEffects.FOSSILIZED_HEART.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerXanarianReputationProvider.PLAYER_XANARIAN_REPUTATION).isPresent()) {
            event.addCapability(new ResourceLocation("undeadremains", "properties"), (ICapabilityProvider)new PlayerXanarianReputationProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerXanarianReputationProvider.PLAYER_XANARIAN_REPUTATION).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerXanarianReputationProvider.PLAYER_XANARIAN_REPUTATION).ifPresent(newStore -> newStore.copyFrom((PlayerXanarianReputation)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerXanarianReputation.class);
    }
}

