/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.helpers;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RNGHelper {
    public static ItemEntity calculateAndDrop(ItemStack stack, float chance, LivingEntity source, Vec3 spawnPos) {
        double magicFind = 0.0;
        if (Math.random() <= RNGHelper.getFinalChance(chance, magicFind)) {
            RNGHelper.trySendDropMessage(stack, magicFind, source, chance);
            ItemEntity entity = new ItemEntity(source.m_9236_(), spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, stack);
            source.m_9236_().m_7967_((Entity)entity);
            return entity;
        }
        return null;
    }

    private static double getFinalChance(float chance, double magicFind) {
        return (double)chance * (1.0 + magicFind / 100.0);
    }

    public static int getCount(LivingEntity source, double value) {
        int i = 0;
        while (value > 0.0) {
            ++i;
            value -= 1.0;
        }
        if (value <= 0.0) {
            return i;
        }
        if (Math.random() <= RNGHelper.getFinalChance((float)value, 0.0)) {
            ++i;
        }
        return i;
    }

    public static ItemStack calculateAndDontDrop(Item item, int maxAmount, @Nullable LivingEntity source, float chance) {
        int amount = 0;
        while (chance > 1.0f) {
            ++amount;
            chance -= 1.0f;
        }
        for (int i = 0; i < maxAmount; ++i) {
            if (!(Math.random() <= RNGHelper.getFinalChance(chance, 0.0))) continue;
            ++amount;
        }
        return RNGHelper.finalize(item, amount, chance, source);
    }

    private static ItemStack finalize(Item item, int amount, float chance, LivingEntity source) {
        if (amount > 0) {
            ItemStack stack = new ItemStack((ItemLike)item, amount);
            RNGHelper.trySendDropMessage(stack, 0.0, source, chance);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static Component createRareDropMessage(ItemStack drop, double magic_find, float chance) {
        return DropRarities.getRarity(chance).makeDisplay().m_130946_("\u00a7l: \u00a7r").m_7220_(drop.m_41786_()).m_130946_("\u00a7b (+" + magic_find + " Magic Find)");
    }

    public static void trySendDropMessage(ItemStack drop, double magicFind, LivingEntity toSend, float chance) {
        if (toSend instanceof Player) {
            Player player = (Player)toSend;
            if ((double)chance < 0.2) {
                player.m_213846_(RNGHelper.createRareDropMessage(drop, magicFind, chance));
            }
        }
    }

    public static enum DropRarities implements DropRarity
    {
        RNGESUS_INCARNATE(1.0E-4f, "rngesus_incarnate", ChatFormatting.RED),
        PRAY_RNGESUS(0.005f, "pray_rngesus", ChatFormatting.LIGHT_PURPLE),
        EXTRAORDINARY(0.02f, "extraordinary", ChatFormatting.DARK_PURPLE),
        RARE(0.1f, "rare", ChatFormatting.AQUA),
        OCCASIONAL(0.2f, "occasional", ChatFormatting.BLUE);

        private final float maxChance;
        private final String translateKey;
        private final ChatFormatting color;

        private DropRarities(float maxChance, String translateKey, ChatFormatting color) {
            this.maxChance = maxChance;
            this.translateKey = translateKey;
            this.color = color;
        }

        @Override
        public float getMaxChance() {
            return this.maxChance;
        }

        public static DropRarities getRarity(float chance) {
            for (DropRarities rarities : DropRarities.values()) {
                if (!(rarities.maxChance >= chance)) continue;
                return rarities;
            }
            return OCCASIONAL;
        }

        public MutableComponent makeDisplay() {
            return Component.m_237115_((String)("rng_drop.rarity." + this.translateKey)).m_130940_(ChatFormatting.BOLD).m_130940_(this.color);
        }

        @Override
        public String getTranslateKey() {
            return this.translateKey;
        }
    }

    private static interface DropRarity {
        public float getMaxChance();

        public String getTranslateKey();
    }
}

