/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.item.armor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.diverginglensestudios.undeadremains.item.armor.ModArmorMaterials;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ModSimpleArmorItem
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.RARE_FOSSIL, (Object)new MobEffectInstance(MobEffects.f_19606_, 200, 1, false, false, true)).put((Object)ModArmorMaterials.METATORBERNITE, (Object)new MobEffectInstance(MobEffects.f_19604_, 200, 1, false, false, true)).put((Object)ModArmorMaterials.SCUTE_MODIFIED_FOSSIL, (Object)new MobEffectInstance(MobEffects.f_19593_, 1, 1, false, false, false)).put((Object)ModArmorMaterials.CLOCK_MODIFIED_FOSSIL, (Object)new MobEffectInstance(MobEffects.f_19619_, 10, 1, false, false, false)).build();

    public ModSimpleArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_()) {
            ArmorItem chestplateItem;
            Item item;
            ItemStack chestplateStack;
            MobEffectInstance effect;
            ArmorItem leggingsItem;
            ItemStack leggingsStack = player.m_150109_().m_36052_(1);
            if (!leggingsStack.m_41619_() && leggingsStack == stack && leggingsStack.m_41720_() instanceof ArmorItem && (leggingsItem = (ArmorItem)leggingsStack.m_41720_()).m_40401_() == ModArmorMaterials.SCUTE_MODIFIED_FOSSIL && (effect = MATERIAL_TO_EFFECT_MAP.get((Object)ModArmorMaterials.SCUTE_MODIFIED_FOSSIL)) != null) {
                player.m_7292_(new MobEffectInstance(effect));
            }
            if (!(chestplateStack = player.m_150109_().m_36052_(2)).m_41619_() && chestplateStack == stack && (item = chestplateStack.m_41720_()) instanceof ArmorItem && (chestplateItem = (ArmorItem)item).m_40401_() == ModArmorMaterials.CLOCK_MODIFIED_FOSSIL) {
                boolean isNight;
                boolean isDay = player.m_9236_().m_46461_();
                boolean bl = isNight = !isDay;
                if (isDay) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2, 0, false, false, false));
                } else if (isNight) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 2, 0, false, false, false));
                }
            }
        }
        if (this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player)) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }
}

