/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.loot.modifiers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.diverginglensestudios.undeadremains.helpers.LootTableHelper;
import net.diverginglensestudios.undeadremains.helpers.RNGHelper;
import net.diverginglensestudios.undeadremains.loot.IConditional;
import net.diverginglensestudios.undeadremains.loot.modifiers.ModLootModifier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddItemModifier
extends ModLootModifier
implements IConditional {
    public static final Codec<AddItemModifier> CODEC = RecordCodecBuilder.create(inst -> AddItemModifier.addItemCodecStart(inst).apply((Applicative)inst, (conditionsIn, item1, chance1, maxAmount1, tagOptional) -> new AddItemModifier((LootItemCondition[])conditionsIn, (Item)item1, chance1.floatValue(), (int)maxAmount1, tagOptional.orElse(null))));
    final Item item;
    final int maxAmount;
    float chance;
    @Nullable
    final CompoundTag tag;

    protected static <T extends AddItemModifier> Products.P5<RecordCodecBuilder.Mu<T>, LootItemCondition[], Item, Float, Integer, Optional<CompoundTag>> addItemCodecStart(RecordCodecBuilder.Instance<T> instance) {
        return AddItemModifier.codecStart(instance).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.INT.optionalFieldOf("maxAmount", (Object)1).forGetter(m -> m.maxAmount)).and((App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(m -> Optional.ofNullable(m.tag)));
    }

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance, int maxAmount, @Nullable CompoundTag tag) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
        this.maxAmount = maxAmount;
        this.tag = tag;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.addItem(arg_0 -> generatedLoot.add(arg_0), context, this.chance);
        return generatedLoot;
    }

    public void addItem(Consumer<ItemStack> consumer, LootContext context, float chance) {
        ItemStack stack = RNGHelper.calculateAndDontDrop(this.item, this.maxAmount, LootTableHelper.getLivingSource(context), chance);
        if (this.tag != null) {
            stack.m_41751_(this.tag);
        }
        if (stack != ItemStack.f_41583_) {
            consumer.accept(stack);
        }
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

