/*
 * Decompiled with CFR 0.152.
 */
package net.diverginglensestudios.undeadremains.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.diverginglensestudios.undeadremains.block.ModBlocks;
import net.diverginglensestudios.undeadremains.worldgen.tree.ModFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class CalipoFoliagePlacer
extends FoliagePlacer {
    public static final Codec<CalipoFoliagePlacer> CODEC = RecordCodecBuilder.create(calipoFoliagePlacerInstance -> CalipoFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)calipoFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)calipoFoliagePlacerInstance, CalipoFoliagePlacer::new));
    private final int height;

    public CalipoFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)ModFoliagePlacers.CALIPO_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos basePos = attachment.m_161451_().m_6630_(offset);
        boolean doubleTrunk = attachment.m_68590_();
        block6: for (int y = 0; y < this.height; ++y) {
            BlockPos layerPos = basePos.m_6630_(y);
            int patternLayer = y % 4;
            switch (patternLayer) {
                case 0: {
                    this.placeSquareLayer(level, setter, random, config, layerPos);
                    continue block6;
                }
                case 1: {
                    this.placeDiamondLayer(level, setter, random, config, layerPos);
                    continue block6;
                }
                case 2: {
                    this.placeSquareLayer(level, setter, random, config, layerPos);
                    continue block6;
                }
                case 3: {
                    this.placeCrossLayer(level, setter, random, config, layerPos);
                }
            }
        }
    }

    private void placeSquareLayer(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos center) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos leafPos = center.m_7918_(dx, -(this.height - 2), dz);
                CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)leafPos);
                this.tryPlaceHangingVine(level, setter, random, leafPos.m_7495_(), 1);
            }
        }
    }

    private void placeDiamondLayer(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos center) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                if (Math.abs(dx) + Math.abs(dz) > 2) continue;
                BlockPos leafPos = center.m_7918_(dx, -(this.height - 2), dz);
                CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)leafPos);
                this.tryPlaceHangingVine(level, setter, random, leafPos.m_7495_(), 1);
            }
        }
    }

    private void placeCrossLayer(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos center) {
        CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)center.m_7918_(1, -(this.height - 2), 0));
        CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)center.m_7918_(-1, -(this.height - 2), 0));
        CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)center.m_7918_(0, -(this.height - 2), 0));
        CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)center.m_7918_(0, -(this.height - 2), 1));
        CalipoFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)center.m_7918_(0, -(this.height - 2), -1));
    }

    private void tryPlaceHangingVine(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, BlockPos startPos, int maxLength) {
        BlockPos.MutableBlockPos pos = startPos.m_122032_();
        if (!level.m_7433_((BlockPos)pos, BlockBehaviour.BlockStateBase::m_60795_)) {
            return;
        }
        if (random.m_188501_() > 0.5f) {
            return;
        }
        for (int i = 0; i < maxLength && level.m_7433_((BlockPos)pos, BlockBehaviour.BlockStateBase::m_60795_); ++i) {
            setter.m_271838_((BlockPos)pos, ((Block)ModBlocks.CALIPO_BERRY_VINE.get()).m_49966_());
            pos.m_122173_(Direction.DOWN);
        }
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return pLocalX == 0 && pLocalZ == 0;
    }
}

