/*
 * Decompiled with CFR 0.152.
 */
package com.white.fish_display.block;

import com.white.fish_display.block.entity.FishPlaqueBlockEntity;
import com.white.fish_display.client.gui.FishPlaqueScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FishPlaqueBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);

    public FishPlaqueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof FishPlaqueBlockEntity) {
            boolean isValidFish;
            FishPlaqueBlockEntity plaque = (FishPlaqueBlockEntity)be;
            if (player.m_6144_() && plaque.hasFish()) {
                if (level.f_46443_) {
                    Minecraft.m_91087_().m_91152_((Screen)new FishPlaqueScreen(plaque));
                }
                return InteractionResult.SUCCESS;
            }
            ItemStack handItem = player.m_21120_(hand);
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)handItem.m_41720_());
            boolean isStringBucket = itemId != null && itemId.m_135815_().endsWith("_bucket");
            boolean isMobBucket = handItem.m_41720_() instanceof MobBucketItem;
            boolean isFishItem = handItem.m_204117_(ItemTags.f_13156_);
            boolean bl = isValidFish = isFishItem || isMobBucket || isStringBucket;
            if (!plaque.hasFish() && isValidFish) {
                if (!level.f_46443_) {
                    ItemStack toStore = handItem.m_41777_();
                    toStore.m_41764_(1);
                    plaque.setFish(toStore);
                    if (!player.m_150110_().f_35937_) {
                        if (isMobBucket || isStringBucket) {
                            if (handItem.m_41613_() > 1) {
                                handItem.m_41774_(1);
                                if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42446_))) {
                                    player.m_36176_(new ItemStack((ItemLike)Items.f_42446_), false);
                                }
                            } else {
                                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                            }
                        } else {
                            handItem.m_41774_(1);
                        }
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (plaque.hasFish()) {
                if (!level.f_46443_) {
                    ItemStack fishToGive = plaque.getFish().m_41777_();
                    if (!player.m_36356_(fishToGive)) {
                        player.m_36176_(fishToGive, false);
                    }
                    plaque.setFish(ItemStack.f_41583_);
                    level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof FishPlaqueBlockEntity) {
                FishPlaqueBlockEntity plaque = (FishPlaqueBlockEntity)be;
                if (!level.f_46443_ && !plaque.getFish().m_41619_()) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)plaque.getFish());
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FishPlaqueBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

