/*
 * Decompiled with CFR 0.152.
 */
package com.white.fish_display.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.white.fish_display.block.FishPlaqueBlock;
import com.white.fish_display.block.entity.FishPlaqueBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class FishPlaqueRenderer
implements BlockEntityRenderer<FishPlaqueBlockEntity> {
    private static final Map<Item, EntityType<?>> FISH_CACHE = new HashMap();

    public FishPlaqueRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FishPlaqueBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getFish();
        if (stack == null || stack.m_41619_() || stack.m_150930_(Items.f_41852_)) {
            return;
        }
        EntityType<?> entityType = this.getEntityTypeFromItem(stack.m_41720_());
        if (entityType == null) {
            return;
        }
        Entity fishEntity = entityType.m_20615_(blockEntity.m_58904_());
        if (fishEntity == null) {
            return;
        }
        this.applyEntityData(fishEntity, stack);
        fishEntity.f_19797_ = 0;
        fishEntity.m_5618_(0.0f);
        fishEntity.m_5616_(0.0f);
        fishEntity.m_146926_(0.0f);
        fishEntity.m_146922_(0.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)FishPlaqueBlock.FACING);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        poseStack.m_85837_(0.0, 0.1, -0.4);
        if (Math.abs(blockEntity.getRotationX() - 90.0f) < 0.1f) {
            poseStack.m_85837_(0.0, 0.1, 0.0);
        } else if (Math.abs(blockEntity.getRotationX() + 90.0f) < 0.1f) {
            poseStack.m_85837_(0.0, -0.1, 0.0);
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f + blockEntity.getRotationX()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        float userScale = blockEntity.getScale();
        poseStack.m_85841_(userScale, userScale, userScale);
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        dispatcher.m_114384_(fishEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, buffer, packedLight);
        dispatcher.m_114468_(true);
        poseStack.m_85849_();
    }

    private void applyEntityData(Entity entity, ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128425_("EntityTag", 10)) {
            CompoundTag entityTag = tag.m_128469_("EntityTag");
            try {
                CompoundTag currentData = new CompoundTag();
                entity.m_20223_(currentData);
                currentData.m_128391_(entityTag);
                entity.m_20258_(currentData);
            }
            catch (Exception currentData) {
                // empty catch block
            }
        }
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            try {
                if (tag.m_128441_("Variant")) {
                    axolotl.m_28464_(Axolotl.Variant.m_262843_((int)tag.m_128451_("Variant")));
                }
            }
            catch (Exception currentData) {
                // empty catch block
            }
        }
        if (entity instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)entity;
            try {
                if (tag.m_128425_("BucketVariantTag", 3)) {
                    int variant = tag.m_128451_("BucketVariantTag");
                    CompoundTag wrapper = new CompoundTag();
                    tropicalFish.m_20223_(wrapper);
                    wrapper.m_128405_("Variant", variant);
                    tropicalFish.m_20258_(wrapper);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private EntityType<?> getEntityTypeFromItem(Item item) {
        if (FISH_CACHE.containsKey(item)) {
            return FISH_CACHE.get(item);
        }
        EntityType type = null;
        if (item == Items.f_42526_) {
            type = EntityType.f_20556_;
        } else if (item == Items.f_42527_) {
            type = EntityType.f_20519_;
        } else if (item == Items.f_42528_) {
            type = EntityType.f_20489_;
        } else if (item == Items.f_42529_) {
            type = EntityType.f_20516_;
        } else if (item == Items.f_151057_) {
            type = EntityType.f_147039_;
        } else if (item == Items.f_220210_) {
            type = EntityType.f_217013_;
        } else {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemId != null) {
                String entityPath;
                ResourceLocation entityId;
                String path = itemId.m_135815_();
                String namespace = itemId.m_135827_();
                if (ForgeRegistries.ENTITY_TYPES.containsKey(itemId)) {
                    type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(itemId);
                } else if (path.endsWith("_bucket") && ForgeRegistries.ENTITY_TYPES.containsKey(entityId = new ResourceLocation(namespace, entityPath = path.substring(0, path.length() - 7)))) {
                    type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
                }
            }
        }
        FISH_CACHE.put(item, type);
        return type;
    }
}

