/*
 * Decompiled with CFR 0.152.
 */
package com.white.fish_display.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.white.fish_display.FishDisplay;
import com.white.fish_display.block.entity.FishPlaqueBlockEntity;
import com.white.fish_display.network.PacketUpdatePlaque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class FishPlaqueScreen
extends Screen {
    private final FishPlaqueBlockEntity plaque;
    private static final float MIN_SCALE = 0.1f;
    private static final float MAX_SCALE = 2.5f;
    private static final float BASE_X = 0.0f;
    private static final float BASE_Y = 0.2f;
    private static final float BASE_Z = 0.5f;
    private static final float OFFSET_FACING_UP = -0.3f;
    private static final float OFFSET_FACING_DOWN = -0.5f;
    private Entity cachedEntity;

    public FishPlaqueScreen(FishPlaqueBlockEntity plaque) {
        super((Component)Component.m_237113_((String)"Configure Plaque"));
        this.plaque = plaque;
    }

    protected void m_7856_() {
        this.cachedEntity = this.createPreviewEntity();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int controlsY = centerY + 80;
        double initialValue = (this.plaque.getScale() - 0.1f) / 2.4f;
        AbstractSliderButton slider = new AbstractSliderButton(centerX - 100, controlsY - 25, 200, 20, (Component)Component.m_237113_((String)"Scale"), initialValue){

            protected void m_5695_() {
                float currentScale = (float)((double)0.1f + this.f_93577_ * (double)2.4f);
                this.m_93666_((Component)Component.m_237113_((String)("Scale: " + String.format("%.1fx", Float.valueOf(currentScale)))));
            }

            protected void m_5697_() {
                FishPlaqueScreen.this.sendUpdate(this.f_93577_);
            }
        };
        slider.m_93666_((Component)Component.m_237113_((String)("Scale: " + String.format("%.1fx", Float.valueOf(this.plaque.getScale())))));
        this.m_142416_((GuiEventListener)slider);
        int btnY = controlsY + 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Down (-90\u00b0)"), b -> {
            this.plaque.setRotationX(-90.0f);
            this.sendUpdate(-1.0);
        }).m_252987_(centerX - 105, btnY, 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Center (0\u00b0)"), b -> {
            this.plaque.setRotationX(0.0f);
            this.sendUpdate(-1.0);
        }).m_252987_(centerX - 35, btnY, 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Up (+90\u00b0)"), b -> {
            this.plaque.setRotationX(90.0f);
            this.sendUpdate(-1.0);
        }).m_252987_(centerX + 35, btnY, 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), b -> this.m_7379_()).m_252987_(centerX - 50, btnY + 30, 100, 20).m_253136_());
    }

    private void sendUpdate(double sliderValue) {
        float newScale = sliderValue == -1.0 ? this.plaque.getScale() : (float)((double)0.1f + sliderValue * (double)2.4f);
        FishDisplay.NETWORK.sendToServer((Object)new PacketUpdatePlaque(this.plaque.m_58899_(), newScale, this.plaque.getRotationX()));
        this.plaque.setScale(newScale);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderPreview(guiGraphics, this.f_96543_ / 2, this.f_96544_ / 2 - 20, 60);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float titleScale = 1.5f;
        poseStack.m_85841_(titleScale, titleScale, titleScale);
        int scaledX = (int)((float)(this.f_96543_ / 2) / titleScale);
        int scaledY = (int)((float)(this.f_96544_ / 2 - 110) / titleScale);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, scaledX, scaledY, 0xFFFFFF);
        poseStack.m_85849_();
    }

    private void renderPreview(GuiGraphics guiGraphics, int x, int y, int size) {
        guiGraphics.m_280509_(x - 60, y - 60, x + 60, y + 60, Integer.MIN_VALUE);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 100.0f);
        poseStack.m_85841_((float)size, (float)size, (float)(-size));
        Lighting.m_166384_();
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)this.plaque.m_58900_().m_60734_()), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), (Level)Minecraft.m_91087_().f_91073_, 0);
        poseStack.m_85849_();
        if (this.cachedEntity != null) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.2f, 0.5f);
            float rotX = this.plaque.getRotationX();
            if (Math.abs(rotX - 90.0f) < 0.1f) {
                poseStack.m_252880_(0.0f, -0.3f, 0.0f);
            } else if (Math.abs(rotX + 90.0f) < 0.1f) {
                poseStack.m_85837_(0.0, 0.0, -0.5);
            }
            float userScale = this.plaque.getScale();
            poseStack.m_85841_(userScale, userScale, userScale);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            dispatcher.m_114468_(false);
            RenderSystem.runAsFancy(() -> dispatcher.m_114384_(this.cachedEntity, 0.0, 0.0, 0.0, 0.0f, -1.0f, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0));
            dispatcher.m_114468_(true);
            poseStack.m_85849_();
        }
        guiGraphics.m_280262_();
        poseStack.m_85849_();
        Lighting.m_84931_();
    }

    private Entity createPreviewEntity() {
        CompoundTag tag;
        ItemStack stack = this.plaque.getFish();
        if (stack.m_41619_()) {
            return null;
        }
        EntityType type = null;
        Item item = stack.m_41720_();
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (item == Items.f_42526_) {
            type = EntityType.f_20556_;
        } else if (item == Items.f_42527_) {
            type = EntityType.f_20519_;
        } else if (item == Items.f_42528_) {
            type = EntityType.f_20489_;
        } else if (item == Items.f_42529_) {
            type = EntityType.f_20516_;
        } else if (item == Items.f_151057_) {
            type = EntityType.f_147039_;
        } else if (item == Items.f_220210_) {
            type = EntityType.f_217013_;
        } else if (itemId != null) {
            ResourceLocation entityId;
            if (ForgeRegistries.ENTITY_TYPES.containsKey(itemId)) {
                type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(itemId);
            } else if (itemId.m_135815_().endsWith("_bucket") && ForgeRegistries.ENTITY_TYPES.containsKey(entityId = new ResourceLocation(itemId.m_135827_(), itemId.m_135815_().replace("_bucket", "")))) {
                type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            }
        }
        if (type == null) {
            return null;
        }
        Entity entity = type.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        if (entity != null && (tag = stack.m_41783_()) != null) {
            if (tag.m_128425_("EntityTag", 10)) {
                try {
                    CompoundTag w = new CompoundTag();
                    entity.m_20223_(w);
                    w.m_128391_(tag.m_128469_("EntityTag"));
                    entity.m_20258_(w);
                }
                catch (Exception w) {
                    // empty catch block
                }
            }
            if (entity instanceof Axolotl) {
                Axolotl ax = (Axolotl)entity;
                if (tag.m_128441_("Variant")) {
                    ax.m_28464_(Axolotl.Variant.m_262843_((int)tag.m_128451_("Variant")));
                }
            }
            if (entity instanceof TropicalFish) {
                TropicalFish tf = (TropicalFish)entity;
                if (tag.m_128425_("BucketVariantTag", 3)) {
                    try {
                        CompoundTag w = new CompoundTag();
                        tf.m_20223_(w);
                        w.m_128405_("Variant", tag.m_128451_("BucketVariantTag"));
                        tf.m_20258_(w);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return entity;
    }

    public boolean m_7043_() {
        return false;
    }
}

