/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.block.Step.StepBlock;
import net.f3rr3.reshaped.block.VerticalStep.VerticalStepBlock;
import net.f3rr3.reshaped.client.render.CompositeBakedModel;
import net.f3rr3.reshaped.util.RuntimeResourceGenerator;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_807;
import net.minecraft.class_813;

public class ReshapedModelLoadingPlugin
implements ModelLoadingPlugin {
    private static void addSegmentModels(ModelLoadingPlugin.Context context, String path) {
        context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path)});
        int max = 16;
        for (int i = 0; i < max; ++i) {
            context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_" + ReshapedModelLoadingPlugin.toBitMask(i, 4))});
        }
        context.addModels(new class_2960[]{new class_2960("reshaped", "item/" + path)});
    }

    private static void addDirectionalModels(ModelLoadingPlugin.Context context, String path) {
        context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_north")});
        context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_south")});
        context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_east")});
        context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_west")});
    }

    private static class_2960 resolveSegmentModelId(class_2248 block, String path, int bitmask) {
        if (bitmask == 15) {
            class_2248 base;
            class_2248 class_22482 = base = Reshaped.MATRIX != null ? Reshaped.MATRIX.getBaseBlock(block) : null;
            if (base != null) {
                class_2960 baseId = class_7923.field_41175.method_10221((Object)base);
                return new class_2960(baseId.method_12836(), "block/" + baseId.method_12832());
            }
            return new class_2960("reshaped", "block/" + path);
        }
        return new class_2960("reshaped", "block/" + path + "_" + ReshapedModelLoadingPlugin.toBitMask(bitmask, 4));
    }

    private static String toBitMask(int value, int length) {
        return String.format("%" + length + "s", Integer.toBinaryString(value)).replace(' ', '0');
    }

    public void onInitializeModelLoader(ModelLoadingPlugin.Context context) {
        context.addModels(new class_2960[]{new class_2960("reshaped", "block/mixed_placeholder")});
        for (class_2248 block : class_7923.field_41175) {
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            if (!id.method_12836().equals("reshaped")) continue;
            String path = id.method_12832();
            if (block instanceof StepBlock) {
                context.registerBlockStateResolver(block, resolverContext -> {
                    for (class_2680 state : block.method_9595().method_11662()) {
                        int bitmask = 0;
                        if (((Boolean)state.method_11654((class_2769)StepBlock.DOWN_FRONT)).booleanValue()) {
                            bitmask |= 8;
                        }
                        if (((Boolean)state.method_11654((class_2769)StepBlock.DOWN_BACK)).booleanValue()) {
                            bitmask |= 4;
                        }
                        if (((Boolean)state.method_11654((class_2769)StepBlock.UP_FRONT)).booleanValue()) {
                            bitmask |= 2;
                        }
                        if (((Boolean)state.method_11654((class_2769)StepBlock.UP_BACK)).booleanValue()) {
                            bitmask |= 1;
                        }
                        class_2960 modelId = ReshapedModelLoadingPlugin.resolveSegmentModelId(block, path, bitmask);
                        class_813 variant = new class_813(modelId, class_1086.field_5350.method_3509(), true, 1);
                        resolverContext.setModel(state, (class_1100)new class_807(Collections.singletonList(variant)));
                    }
                });
                ReshapedModelLoadingPlugin.addSegmentModels(context, path);
                continue;
            }
            if (block instanceof VerticalStepBlock) {
                context.registerBlockStateResolver(block, resolverContext -> {
                    for (class_2680 state : block.method_9595().method_11662()) {
                        int bitmask = 0;
                        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.NORTH_WEST)).booleanValue()) {
                            bitmask |= 8;
                        }
                        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.NORTH_EAST)).booleanValue()) {
                            bitmask |= 4;
                        }
                        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.SOUTH_WEST)).booleanValue()) {
                            bitmask |= 2;
                        }
                        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.SOUTH_EAST)).booleanValue()) {
                            bitmask |= 1;
                        }
                        class_2960 modelId = ReshapedModelLoadingPlugin.resolveSegmentModelId(block, path, bitmask);
                        class_813 variant = new class_813(modelId, class_1086.field_5350.method_3509(), true, 1);
                        resolverContext.setModel(state, (class_1100)new class_807(Collections.singletonList(variant)));
                    }
                });
                ReshapedModelLoadingPlugin.addSegmentModels(context, path);
                continue;
            }
            String templateType = RuntimeResourceGenerator.getTemplateType(block, id);
            if (templateType != null) {
                String finalTemplateType = templateType;
                context.registerBlockStateResolver(block, resolverContext -> {
                    String blockStateJson;
                    class_2248 base;
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("path", path);
                    class_2248 class_22482 = base = Reshaped.MATRIX != null ? Reshaped.MATRIX.getBaseBlock(block) : null;
                    if (base != null) {
                        class_2960 baseId = class_7923.field_41175.method_10221((Object)base);
                        placeholders.put("base_model", baseId.method_12836() + ":block/" + baseId.method_12832());
                    }
                    if ((blockStateJson = RuntimeResourceGenerator.generateBlockStateJson(finalTemplateType, placeholders)) != null) {
                        try {
                            JsonObject json = JsonParser.parseString((String)blockStateJson).getAsJsonObject();
                            if (json.has("variants")) {
                                JsonObject variants = json.getAsJsonObject("variants");
                                for (class_2680 state : block.method_9595().method_11662()) {
                                    String stateString = RuntimeResourceGenerator.serializeState(state);
                                    JsonElement variantElem = RuntimeResourceGenerator.findMatchingVariant(variants, stateString);
                                    if (variantElem == null) continue;
                                    class_813 variant = RuntimeResourceGenerator.parseVariant(variantElem);
                                    resolverContext.setModel(state, (class_1100)new class_807(Collections.singletonList(variant)));
                                }
                            }
                        }
                        catch (Exception e) {
                            Reshaped.LOGGER.error("Failed to apply block state template for {}", (Object)id, (Object)e);
                        }
                    }
                });
            } else if (path.startsWith("mixed_")) {
                class_2960 placeholder = new class_2960("reshaped", "block/mixed_placeholder");
                context.registerBlockStateResolver(block, resolverContext -> {
                    class_807 model = new class_807(Collections.singletonList(new class_813(placeholder, null, false, 1)));
                    for (class_2680 state : block.method_9595().method_11662()) {
                        resolverContext.setModel(state, (class_1100)model);
                    }
                });
            }
            context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path)});
            if (block instanceof class_2510) {
                context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_inner")});
                context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_outer")});
            } else if (block instanceof class_2482) {
                context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_top")});
            }
            if (path.endsWith("_vertical_slab")) {
                ReshapedModelLoadingPlugin.addDirectionalModels(context, path);
            }
            if (path.endsWith("_corner")) {
                for (int i = 0; i < 256; ++i) {
                    context.addModels(new class_2960[]{new class_2960("reshaped", "block/" + path + "_" + ReshapedModelLoadingPlugin.toBitMask(i, 8))});
                }
            }
            context.addModels(new class_2960[]{new class_2960("reshaped", "item/" + path)});
        }
        context.resolveModel().register(resolverContext -> {
            String normalizedPath;
            String json;
            class_2960 id = resolverContext.id();
            if (id.method_12836().equals("reshaped") && (json = RuntimeResourceGenerator.generateModelJson(normalizedPath = RuntimeResourceGenerator.normalizePath(id.method_12832()))) != null) {
                try {
                    return class_793.method_3430((String)json);
                }
                catch (Exception e) {
                    Reshaped.LOGGER.error("Failed to deserialize dynamic model: {}", (Object)id, (Object)e);
                }
            }
            return null;
        });
        context.resolveModel().register(resolverContext -> null);
        context.modifyModelAfterBake().register((model, context1) -> {
            class_2960 id = context1.id();
            if (id.method_12836().equals("reshaped")) {
                if (id.method_12832().endsWith("_corner") && !id.method_12832().contains("_corner_")) {
                    return new CompositeBakedModel(model);
                }
                if (id.method_12832().endsWith("_vertical_step") && !id.method_12832().contains("_vertical_step_")) {
                    return new CompositeBakedModel(model);
                }
                if (id.method_12832().endsWith("_step") && !id.method_12832().contains("_step_")) {
                    return new CompositeBakedModel(model);
                }
                if (id.method_12832().startsWith("mixed_")) {
                    return new CompositeBakedModel(model);
                }
            }
            return model;
        });
    }
}

