/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.client.gui;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CircleTexture {
    private static final Map<String, CachedCircle> CACHE = new HashMap<String, CachedCircle>();

    public static CachedCircle getOrCreateCircle(int outerRadius, int innerRadius, int color, float alpha, float outlineThickness, float startAngle, float stopAngle) {
        String key = outerRadius + "|" + innerRadius + "|" + color + "|" + Math.round(alpha * 1000.0f) + "|" + Math.round(outlineThickness * 10.0f) + "|" + Math.round(startAngle * 100.0f) + "|" + Math.round(stopAngle * 100.0f);
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        int size = (outerRadius + Math.round(outlineThickness)) * 2 + 4;
        class_1011 image = new class_1011(class_1011.class_1012.field_4997, size, size, false);
        int emptyColor = color & 0xFFFFFF;
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                image.method_4305(x, y, emptyColor);
            }
        }
        float cx = (float)size * 0.5f;
        float cy = (float)size * 0.5f;
        float inner = Math.max(0, innerRadius);
        float aa = 1.0f;
        float startRad = (float)Math.toRadians(startAngle);
        float stopRad = (float)Math.toRadians(stopAngle);
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                float dx = (float)x + 0.5f - cx;
                float dy = (float)y + 0.5f - cy;
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                float angle = (float)Math.atan2(dy, dx);
                float a = 0.0f;
                if (CircleTexture.isAngleInRange(angle, startRad, stopRad)) {
                    float fillA = alpha;
                    if (inner > 0.0f) {
                        fillA = outlineThickness > 0.0f ? (fillA *= CircleTexture.smoothstep(0.0f, aa, dist - inner + 0.5f)) : (fillA *= CircleTexture.smoothstep(0.0f, aa, dist - inner));
                    }
                    fillA = outlineThickness > 0.0f ? (fillA *= CircleTexture.smoothstep(0.0f, aa, (float)outerRadius - dist + 0.5f)) : (fillA *= CircleTexture.smoothstep(0.0f, aa, (float)outerRadius - dist));
                    float outlineA = 0.0f;
                    if (outlineThickness > 0.0f) {
                        float outerStroke = CircleTexture.smoothstep(outlineThickness + aa, outlineThickness - aa, Math.abs(dist - (float)outerRadius));
                        float innerStroke = 0.0f;
                        if (inner > 0.0f) {
                            innerStroke = CircleTexture.smoothstep(outlineThickness + aa, outlineThickness - aa, Math.abs(dist - inner));
                        }
                        outlineA = alpha * Math.max(outerStroke, innerStroke);
                    }
                    a = Math.max(fillA, outlineA);
                }
                int alpha8bit = Math.min(255, Math.round(a * 255.0f));
                int argb = alpha8bit << 24 | color & 0xFFFFFF;
                image.method_4305(x, y, argb);
            }
        }
        class_1043 texture = new class_1043(image);
        texture.method_4527(true, false);
        class_2960 textureId = new class_2960("reshaped", "circle_" + key.hashCode());
        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
        CachedCircle cached = new CachedCircle(textureId, size);
        CACHE.put(key, cached);
        return cached;
    }

    private static boolean isAngleInRange(float angle, float startAngle, float stopAngle) {
        while ((double)angle < -Math.PI) {
            angle += (float)Math.PI * 2;
        }
        while ((double)angle > Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        while ((double)startAngle < -Math.PI) {
            startAngle += (float)Math.PI * 2;
        }
        while ((double)startAngle > Math.PI) {
            startAngle -= (float)Math.PI * 2;
        }
        while ((double)stopAngle < -Math.PI) {
            stopAngle += (float)Math.PI * 2;
        }
        while ((double)stopAngle > Math.PI) {
            stopAngle -= (float)Math.PI * 2;
        }
        if (startAngle <= stopAngle) {
            return angle >= startAngle && angle <= stopAngle;
        }
        return angle >= startAngle || angle <= stopAngle;
    }

    private static float smoothstep(float e0, float e1, float x) {
        float t = (x - e0) / (e1 - e0);
        t = Math.max(0.0f, Math.min(1.0f, t));
        return t * t * (3.0f - 2.0f * t);
    }

    public static class CachedCircle {
        public final class_2960 textureId;
        public final int size;

        CachedCircle(class_2960 textureId, int size) {
            this.textureId = textureId;
            this.size = size;
        }
    }
}

