/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.client.ModKeybindings;
import net.f3rr3.reshaped.client.gui.CircleTexture;
import net.f3rr3.reshaped.network.NetworkHandler;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;

public class RadialMenuScreen
extends class_437 {
    private static final class_2960 HOTBAR_TEXTURE = new class_2960("minecraft", "textures/gui/widgets.png");
    private static final float BACKGROUND_RESOLUTION_MULTIPLIER = 4.0f;
    private static final int RADIAL_RADIUS = 80;
    private static final int RADIAL_RING_THICKNESS = 20;
    private static final int MIN_HOVER_DIST_SQ = 400;
    private static final int MAX_HOVER_DIST_SQ = 15000;
    private final List<class_2248> blocks;
    private final int slot;
    private final class_2248 currentBlock;
    private final class_2248 baseBlock;
    private int hoveredIndex = -1;
    private float centerBlockAngle = 0.0f;
    private float angularSpeed = 0.0f;
    private float lastRelativeAngle = 0.0f;
    private float relativeAngle = 0.0f;
    private Runnable pendingAction;
    private int selectedSlotInSortedHotbar;

    public RadialMenuScreen(List<class_2248> blocks, int slot, class_2248 currentBlock, class_2248 baseBlock) {
        super((class_2561)class_2561.method_43470((String)"Radial Menu"));
        this.blocks = blocks;
        this.slot = slot;
        this.currentBlock = currentBlock;
        this.baseBlock = baseBlock;
    }

    private static void drawScaledItem(class_332 context, class_1799 stack, int centerX, int centerY, float scale) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale);
        int scaledX = Math.round((float)centerX / scale - 8.0f);
        int scaledY = Math.round((float)centerY / scale - 8.0f);
        context.method_51427(stack, scaledX, scaledY);
        matrices.method_22909();
    }

    public static void drawRotatedItem(class_332 context, class_1799 stack, int x, int y, float angleRad, float scale) {
        class_4587 matrices = context.method_51448();
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_1087 model = itemRenderer.method_4019(stack, null, null, 0);
        boolean is3D = model.method_4712();
        if (!is3D) {
            scale *= 0.6f;
        }
        matrices.method_22903();
        Vector3f lightDir1 = new Vector3f(0.2f, -1.0f, -0.7f).normalize();
        Vector3f lightDir2 = new Vector3f(-0.2f, -1.0f, 0.7f).normalize();
        RenderSystem.setShaderLights((Vector3f)lightDir1, (Vector3f)lightDir2);
        matrices.method_46416((float)x, (float)(y - 16), -100.0f);
        matrices.method_22905(scale * 16.0f, scale * -16.0f, scale * 16.0f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(30.0f));
        matrices.method_22907(class_7833.field_40716.rotation(angleRad));
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        itemRenderer.method_23178(stack, class_811.field_4319, 0xF000F0, class_4608.field_21444, matrices, (class_4597)immediate, (class_1937)class_310.method_1551().field_1687, 0);
        immediate.method_22993();
        matrices.method_22909();
        class_308.method_24211();
    }

    private static void drawCircleSlice(class_332 context, int centerX, int centerY, int outerRadius, int innerRadius, int slice, int NoOfSlices, int color) {
        RadialMenuScreen.resetRender();
        float sectionWidth = 360.0f / (float)NoOfSlices;
        float startAngle = sectionWidth * ((float)slice - 0.5f);
        float endAngle = sectionWidth * ((float)slice + 0.5f);
        int resOuter = Math.round((float)outerRadius * 4.0f);
        int resInner = Math.round((float)innerRadius * 4.0f);
        CircleTexture.CachedCircle circle = CircleTexture.getOrCreateCircle(resOuter, resInner, color, 0.7f, 4.0f, startAngle, endAngle);
        int displaySize = Math.round((float)circle.size / 4.0f);
        int x0 = centerX - displaySize / 2;
        int y0 = centerY - displaySize / 2;
        context.method_25293(circle.textureId, x0, y0, displaySize, displaySize, 0.0f, 0.0f, circle.size, circle.size, circle.size, circle.size);
    }

    private static float getRelativeAngleToMouse(int xOrigin, int yOrigin, int xTarget, int yTarget) {
        float yDiff = yTarget - yOrigin;
        float xDiff = xTarget - xOrigin;
        return (float)Math.atan2(yDiff, xDiff);
    }

    public static boolean isOpen() {
        class_310 client = class_310.method_1551();
        return client.field_1755 instanceof RadialMenuScreen;
    }

    private static void drawHotbarTexture(class_332 context, int slot, int x, int y) {
        if (slot == -1) {
            context.method_25302(HOTBAR_TEXTURE, x - 2, y - 1, 0, 22, 24, 22);
            return;
        }
        int u = slot == 1 ? 0 : (slot - 1) * 20 + 1;
        int v = 0;
        int tileWidth = slot == 1 || slot == 9 ? 21 : 20;
        int tileHeight = 22;
        if (slot == 1) {
            --x;
        }
        context.method_25302(HOTBAR_TEXTURE, x, y, u, v, tileWidth, tileHeight);
    }

    private static void resetRender() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(class_757::method_34542);
    }

    public void method_25393() {
        super.method_25393();
        float delta = this.relativeAngle - this.lastRelativeAngle;
        if ((double)delta > Math.PI) {
            delta -= (float)Math.PI * 2;
        } else if ((double)delta < -Math.PI) {
            delta += (float)Math.PI * 2;
        }
        this.angularSpeed += delta;
        this.lastRelativeAngle = this.relativeAngle;
        float targetAngularSpeed = 0.5f;
        float springStrength = 2.0f;
        float dt = 0.05f;
        float torque = springStrength * (targetAngularSpeed - this.angularSpeed);
        this.angularSpeed += torque * dt;
        this.centerBlockAngle += this.angularSpeed * dt;
        boolean isHeld = false;
        if (this.field_22787 != null) {
            long handle = this.field_22787.method_22683().method_4490();
            class_3675.class_306 boundKey = ModKeybindings.OPEN_RADIAL_MENU.method_1429();
            if (boundKey.method_1442() == class_3675.class_307.field_1668) {
                isHeld = class_3675.method_15987((long)handle, (int)boundKey.method_1444());
            } else if (boundKey.method_1442() == class_3675.class_307.field_1672) {
                boolean bl = isHeld = GLFW.glfwGetMouseButton((long)handle, (int)boundKey.method_1444()) == 1;
            }
        }
        if (!isHeld) {
            this.selectHovered(true);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.blocks.isEmpty()) {
            return;
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        double angleStep = Math.PI * 2 / (double)this.blocks.size();
        this.relativeAngle = RadialMenuScreen.getRelativeAngleToMouse(centerX, centerY, mouseX, mouseY);
        this.updateHoveredIndex(centerX, centerY, mouseX, mouseY, angleStep);
        this.renderFilteredHotbar(context);
        this.renderBackgroundSlices(context, centerX, centerY);
        this.renderItems(context, centerX, centerY, angleStep);
        this.renderTooltips(context, centerX, centerY);
        if (this.isCtrlPressed()) {
            this.renderDebugInfo(context, centerX, centerY, this.relativeAngle);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.pendingAction != null) {
            this.pendingAction.run();
            this.pendingAction = null;
        }
    }

    private void updateHoveredIndex(int centerX, int centerY, int mouseX, int mouseY, double angleStep) {
        double dx = mouseX - centerX;
        double dy = mouseY - centerY;
        double distSq = dx * dx + dy * dy;
        this.hoveredIndex = -1;
        if (distSq > 400.0 && distSq < 15000.0) {
            double mouseAngle = Math.atan2(dy, dx);
            if (mouseAngle < 0.0) {
                mouseAngle += Math.PI * 2;
            }
            this.hoveredIndex = (int)Math.round(mouseAngle / angleStep) % this.blocks.size();
        }
    }

    private void renderBackgroundSlices(class_332 context, int centerX, int centerY) {
        int halfThickness = 10;
        int innerDiam = 80 - halfThickness;
        int outerDiam = 80 + halfThickness;
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (i == this.hoveredIndex) {
                RadialMenuScreen.drawCircleSlice(context, centerX, centerY, outerDiam + 6, innerDiam - 4, i, this.blocks.size(), 0x40666666);
                continue;
            }
            RadialMenuScreen.drawCircleSlice(context, centerX, centerY, outerDiam, innerDiam, i, this.blocks.size(), 0x7F333333);
        }
    }

    private void renderItems(class_332 context, int centerX, int centerY, double angleStep) {
        for (int i = 0; i < this.blocks.size(); ++i) {
            double angle = (double)i * angleStep;
            class_2248 block = this.blocks.get(i);
            class_1799 stack = new class_1799((class_1935)block);
            if (i == this.hoveredIndex || block == this.currentBlock && this.hoveredIndex == -1) {
                RadialMenuScreen.drawRotatedItem(context, stack, centerX, centerY + 16, -this.centerBlockAngle, 8.0f);
            }
            int x = centerX + (int)(80.0 * Math.cos(angle));
            int y = centerY + (int)(80.0 * Math.sin(angle));
            float scale = this.baseBlock == block && this.isCtrlPressed() ? 1.5f : 1.0f;
            RadialMenuScreen.drawScaledItem(context, stack, x, y, scale);
        }
    }

    private void renderTooltips(class_332 context, int centerX, int centerY) {
        if (this.hoveredIndex != -1) {
            class_2248 block = this.blocks.get(this.hoveredIndex);
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>(List.of(block.method_9518()));
            this.drawCenteredTooltip(context, tooltip, centerX, centerY / 6);
            if (this.isCtrlPressed()) {
                String reason = Reshaped.MATRIX != null ? Reshaped.MATRIX.getReason(block) : "Unknown reason";
                String blockInstance = block.getClass().getSimpleName();
                ArrayList<class_5250> debugTooltip = new ArrayList<class_5250>(List.of(class_2561.method_43470((String)blockInstance).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), class_2561.method_43470((String)reason).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})));
                context.method_51434(this.field_22793, debugTooltip, -8, 16);
            }
        }
    }

    private boolean isCtrlPressed() {
        if (this.field_22787 == null) {
            return false;
        }
        long handle = this.field_22787.method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)341) == 1 || GLFW.glfwGetKey((long)handle, (int)345) == 1;
    }

    private void renderDebugInfo(class_332 context, int centerX, int centerY, float relativeAngle) {
        String debugText = "Radial: Hover " + this.hoveredIndex + " | Items: " + this.blocks.size() + " | relativeAngle: " + relativeAngle;
        int textX = centerX - 150;
        int textY = centerY + 80 + 20;
        context.method_25294(textX - 2, textY - 2, textX + 150, textY + 12, -16777216);
        context.method_51433(this.field_22793, debugText, textX, textY, 0xFFFFFF, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.selectHovered(true);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_2248 block;
            class_1799 stack;
            List<class_1799> filtered;
            if (this.hoveredIndex != -1) {
                this.selectHovered(false);
            }
            if ((filtered = this.generateFilteredHotbar()).isEmpty()) {
                return true;
            }
            int i = this.field_22787.field_1724.method_31548().field_7545;
            int j = (int)Math.signum(amount);
            int newSlot = i;
            do {
                class_2248 class_22482;
                newSlot -= j;
                while (newSlot < 0) {
                    newSlot += 9;
                }
                while (newSlot >= 9) {
                    newSlot -= 9;
                }
                stack = this.field_22787.field_1724.method_31548().method_5438(newSlot);
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1747) {
                    class_1747 blockItem = (class_1747)class_17922;
                    class_22482 = blockItem.method_7711();
                    continue;
                }
                class_22482 = block = null;
            } while (stack.method_7960() || !Reshaped.MATRIX.hasBlock(block));
            this.changeSlot(newSlot);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void changeSlot(int newSlot) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_31548().field_7545 = newSlot;
            this.pendingAction = () -> {
                class_1799 stack = this.field_22787.field_1724.method_6047();
                class_1792 patt0$temp = stack.method_7909();
                if (patt0$temp instanceof class_1747) {
                    List<class_2248> column;
                    class_1747 blockItem = (class_1747)patt0$temp;
                    class_2248 block = blockItem.method_7711();
                    if (Reshaped.MATRIX != null && Reshaped.MATRIX.hasBlock(block) && !(column = Reshaped.MATRIX.getColumn(block)).isEmpty()) {
                        class_2248 baseBlock = Reshaped.MATRIX.getBaseBlock(block);
                        this.field_22787.method_1507((class_437)new RadialMenuScreen(column, newSlot, block, baseBlock));
                        return;
                    }
                }
                this.method_25419();
            };
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.field_22787 != null && this.field_22787.field_1690 != null) {
            for (int i = 0; i < 9; ++i) {
                if (!this.field_22787.field_1690.field_1852[i].method_1417(keyCode, scanCode)) continue;
                this.changeSlot(i);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void selectHovered(boolean close) {
        if (this.hoveredIndex != -1) {
            class_2248 selectedBlock = this.blocks.get(this.hoveredIndex);
            NetworkHandler.sendConvertBlockPacket(class_7923.field_41175.method_10221((Object)selectedBlock), this.slot);
        }
        if (close) {
            this.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    private void renderFilteredHotbar(class_332 context) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        List<class_1799> filtered = this.generateFilteredHotbar();
        if (filtered.isEmpty()) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int slotSize = 20;
        int totalWidth = filtered.size() * slotSize;
        int xStart = (screenWidth - totalWidth) / 2;
        int y = screenHeight - 22;
        int slotWidth = 20;
        for (int i = 0; i < filtered.size(); ++i) {
            int x = xStart + i * slotWidth;
            RadialMenuScreen.resetRender();
            int slot = i == filtered.size() - 1 ? 9 : i + 1;
            RadialMenuScreen.drawHotbarTexture(context, slot, x, y);
            class_1799 stack = filtered.get(i);
            context.method_51427(stack, x + 2, y + 3);
            context.method_51431(this.field_22793, stack, x + 2, y + 3);
        }
        int x = xStart + this.selectedSlotInSortedHotbar * slotWidth;
        y = screenHeight - 22;
        RadialMenuScreen.drawHotbarTexture(context, -1, x, y);
    }

    private List<class_1799> generateFilteredHotbar() {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        class_1661 inv = client.field_1724.method_31548();
        ArrayList<class_1799> filtered = new ArrayList<class_1799>();
        int selectedSlot = client.field_1724.method_31548().field_7545;
        for (int i = 0; i < 9; ++i) {
            class_2248 block;
            class_1799 stack = inv.method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                v0 = blockItem.method_7711();
            } else {
                v0 = block = null;
            }
            if (stack.method_7960() || !Reshaped.MATRIX.hasBlock(block)) continue;
            filtered.add(stack);
            if (i != selectedSlot) continue;
            this.selectedSlotInSortedHotbar = filtered.size() - 1;
        }
        return filtered;
    }

    private void drawCenteredTooltip(class_332 context, List<class_2561> lines, int centerX, int y) {
        int maxWidth = 0;
        for (class_2561 line : lines) {
            maxWidth = Math.max(maxWidth, this.field_22793.method_27525((class_5348)line));
        }
        int tooltipPadding = 12;
        int x = centerX - maxWidth / 2 - tooltipPadding;
        context.method_51434(this.field_22793, lines, x, y);
    }
}

