/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.client.render;

import java.util.function.Supplier;
import net.f3rr3.reshaped.block.Corner.CornerBlock;
import net.f3rr3.reshaped.block.Corner.CornerBlockEntity;
import net.f3rr3.reshaped.block.Corner.MixedCornerBlock;
import net.f3rr3.reshaped.block.Slab.MixedSlabBlock;
import net.f3rr3.reshaped.block.Slab.SlabBlockEntity;
import net.f3rr3.reshaped.block.Step.MixedStepBlock;
import net.f3rr3.reshaped.block.Step.StepBlock;
import net.f3rr3.reshaped.block.Step.StepBlockEntity;
import net.f3rr3.reshaped.block.VerticalSlab.MixedVerticalSlabBlock;
import net.f3rr3.reshaped.block.VerticalSlab.VerticalSlabBlock;
import net.f3rr3.reshaped.block.VerticalSlab.VerticalSlabBlockEntity;
import net.f3rr3.reshaped.block.VerticalStep.MixedVerticalStepBlock;
import net.f3rr3.reshaped.block.VerticalStep.VerticalStepBlock;
import net.f3rr3.reshaped.block.VerticalStep.VerticalStepBlockEntity;
import net.f3rr3.reshaped.util.BlockSegmentUtils;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class CompositeBakedModel
extends ForwardingBakedModel {
    public CompositeBakedModel(class_1087 baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2248 block = state.method_26204();
        class_2586 be = blockView.method_8321(pos);
        if (block instanceof CornerBlock || block instanceof MixedCornerBlock) {
            this.renderCornerBlock(blockView, state, pos, randomSupplier, context, be);
        } else if (block instanceof VerticalStepBlock || block instanceof MixedVerticalStepBlock) {
            this.renderVerticalStepBlock(blockView, state, pos, randomSupplier, context, be);
        } else if (block instanceof StepBlock || block instanceof MixedStepBlock) {
            this.renderStepBlock(blockView, state, pos, randomSupplier, context, be);
        } else if (block instanceof VerticalSlabBlock || block instanceof MixedVerticalSlabBlock) {
            this.renderVerticalSlabBlock(blockView, state, pos, randomSupplier, context, be);
        } else if (block instanceof class_2482 || block instanceof MixedSlabBlock) {
            this.renderSlabBlock(blockView, state, pos, randomSupplier, context, be);
        } else {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
    }

    private void renderCornerBlock(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, class_2586 be) {
        CornerBlockEntity entity;
        CornerBlockEntity cbe = be instanceof CornerBlockEntity ? (entity = (CornerBlockEntity)be) : null;
        for (int i = 0; i < 8; ++i) {
            class_2960 materialId;
            if (!this.isCornerBitSet(state, i)) continue;
            class_2960 class_29602 = materialId = cbe != null ? cbe.getCornerMaterial(i) : null;
            if (materialId == null) {
                if (!(state.method_26204() instanceof CornerBlock)) continue;
                materialId = class_7923.field_41175.method_10221((Object)state.method_26204());
            }
            String path = this.cleanPath(materialId.method_12832(), "_corner");
            String mask = this.getCornerBitMask(i);
            class_2960 segmentModelId = new class_2960("reshaped", "block/" + path + "_corner_" + mask);
            this.renderModel(segmentModelId, blockView, state, pos, randomSupplier, context);
        }
    }

    private void renderVerticalStepBlock(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, class_2586 be) {
        VerticalStepBlockEntity entity;
        VerticalStepBlockEntity verticalStepBlockEntity = be instanceof VerticalStepBlockEntity ? (entity = (VerticalStepBlockEntity)be) : null;
        for (int i = 0; i < 4; ++i) {
            class_2960 materialId;
            if (!this.isVerticalStepBitSet(state, i)) continue;
            class_2960 class_29602 = materialId = verticalStepBlockEntity != null ? verticalStepBlockEntity.getMaterial(i) : null;
            if (materialId == null) {
                if (!(state.method_26204() instanceof VerticalStepBlock)) continue;
                materialId = class_7923.field_41175.method_10221((Object)state.method_26204());
            }
            String path = this.cleanPath(materialId.method_12832(), "_vertical_step");
            String mask = this.getVerticalStepBitMask(i);
            class_2960 segmentModelId = new class_2960("reshaped", "block/" + path + "_vertical_step_" + mask);
            this.renderModel(segmentModelId, blockView, state, pos, randomSupplier, context);
        }
    }

    private void renderStepBlock(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, class_2586 be) {
        StepBlockEntity entity;
        StepBlockEntity stepBlockEntity = be instanceof StepBlockEntity ? (entity = (StepBlockEntity)be) : null;
        for (int i = 0; i < 4; ++i) {
            class_2960 materialId;
            if (!this.isStepBitSet(state, i)) continue;
            class_2960 class_29602 = materialId = stepBlockEntity != null ? stepBlockEntity.getMaterial(i) : null;
            if (materialId == null) {
                if (!(state.method_26204() instanceof StepBlock)) continue;
                materialId = class_7923.field_41175.method_10221((Object)state.method_26204());
            }
            String path = this.cleanPath(materialId.method_12832(), "_step");
            String mask = this.getStepBitMask(i);
            class_2960 segmentModelId = new class_2960("reshaped", "block/" + path + "_step_" + mask);
            StepBlock.StepAxis axis = (StepBlock.StepAxis)((Object)state.method_11654(StepBlock.AXIS));
            boolean rotate180 = axis == StepBlock.StepAxis.EAST_WEST;
            boolean rotate270 = axis == StepBlock.StepAxis.NORTH_SOUTH;
            context.pushTransform(quad -> {
                class_2350 rotatedNominal;
                for (int idx = 0; idx < 4; ++idx) {
                    float x = quad.x(idx);
                    float z = quad.z(idx);
                    float newX = x;
                    float newZ = z;
                    if (rotate180) {
                        newX = 1.0f - x;
                        newZ = 1.0f - z;
                    } else if (rotate270) {
                        newX = z;
                        newZ = 1.0f - x;
                    }
                    quad.pos(idx, newX, quad.y(idx), newZ);
                }
                class_2350 rotatedCull = this.rotateY(quad.cullFace(), rotate180, rotate270);
                if (rotatedCull != quad.cullFace()) {
                    quad.cullFace(rotatedCull);
                }
                if ((rotatedNominal = this.rotateY(quad.nominalFace(), rotate180, rotate270)) != quad.nominalFace()) {
                    quad.nominalFace(rotatedNominal);
                }
                return true;
            });
            this.renderModel(segmentModelId, blockView, state, pos, randomSupplier, context);
            context.popTransform();
        }
    }

    private void renderVerticalSlabBlock(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, class_2586 be) {
        VerticalSlabBlockEntity entity;
        VerticalSlabBlockEntity verticalSlabBlockEntity = be instanceof VerticalSlabBlockEntity ? (entity = (VerticalSlabBlockEntity)be) : null;
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(MixedVerticalSlabBlock.AXIS);
        for (int i = 0; i < 2; ++i) {
            class_2248 materialBlock;
            class_2960 materialId;
            if (!this.isVerticalSlabBitSet(state, i)) continue;
            class_2960 class_29602 = materialId = verticalSlabBlockEntity != null ? verticalSlabBlockEntity.getMaterial(i) : null;
            if (materialId == null) {
                if (!(state.method_26204() instanceof VerticalSlabBlock)) continue;
                materialId = class_7923.field_41175.method_10221((Object)state.method_26204());
            }
            if (!((materialBlock = (class_2248)class_7923.field_41175.method_10223(materialId)) instanceof VerticalSlabBlock)) continue;
            class_2350 targetFacing = axis == class_2350.class_2351.field_11051 ? (i == 0 ? class_2350.field_11043 : class_2350.field_11035) : (i == 0 ? class_2350.field_11039 : class_2350.field_11034);
            class_2680 targetState = (class_2680)materialBlock.method_9564().method_11657((class_2769)VerticalSlabBlock.FACING, (Comparable)targetFacing);
            class_1087 model = class_310.method_1551().method_1541().method_3349(targetState);
            this.renderModel(model, blockView, state, pos, randomSupplier, context);
        }
    }

    private void renderSlabBlock(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, class_2586 be) {
        SlabBlockEntity entity;
        SlabBlockEntity slabBlockEntity = be instanceof SlabBlockEntity ? (entity = (SlabBlockEntity)be) : null;
        for (int i = 0; i < 2; ++i) {
            class_2248 materialBlock;
            class_2960 materialId;
            if (!this.isSlabBitSet(state, i)) continue;
            class_2960 class_29602 = materialId = slabBlockEntity != null ? slabBlockEntity.getMaterial(i) : null;
            if (materialId == null) {
                if (!(state.method_26204() instanceof class_2482)) continue;
                materialId = class_7923.field_41175.method_10221((Object)state.method_26204());
            }
            if (!((materialBlock = (class_2248)class_7923.field_41175.method_10223(materialId)) instanceof class_2482)) continue;
            class_2771 type = i == 0 ? class_2771.field_12681 : class_2771.field_12679;
            class_2680 targetState = (class_2680)materialBlock.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)type);
            class_1087 model = class_310.method_1551().method_1541().method_3349(targetState);
            this.renderModel(model, blockView, state, pos, randomSupplier, context);
        }
    }

    private void renderModel(class_2960 modelId, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_1087 model = class_310.method_1551().method_1554().getModel(modelId);
        this.renderModel(model, blockView, state, pos, randomSupplier, context);
    }

    private void renderModel(class_1087 model, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        if (model != null && model != class_310.method_1551().method_1554().method_4744()) {
            model.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
    }

    private String cleanPath(String path, String suffixToRemove) {
        if (path.endsWith(suffixToRemove)) {
            return path.substring(0, path.length() - suffixToRemove.length());
        }
        return path;
    }

    private boolean isCornerBitSet(class_2680 state, int index) {
        if (index < 0 || index >= BlockSegmentUtils.CORNER_PROPERTIES.length) {
            return false;
        }
        return (Boolean)state.method_11654((class_2769)BlockSegmentUtils.CORNER_PROPERTIES[index]);
    }

    private String getCornerBitMask(int index) {
        char[] bits = "00000000".toCharArray();
        bits[index] = 49;
        return new String(bits);
    }

    private boolean isVerticalStepBitSet(class_2680 state, int index) {
        return switch (index) {
            case 0 -> (Boolean)state.method_11654((class_2769)VerticalStepBlock.NORTH_WEST);
            case 1 -> (Boolean)state.method_11654((class_2769)VerticalStepBlock.NORTH_EAST);
            case 2 -> (Boolean)state.method_11654((class_2769)VerticalStepBlock.SOUTH_WEST);
            case 3 -> (Boolean)state.method_11654((class_2769)VerticalStepBlock.SOUTH_EAST);
            default -> false;
        };
    }

    private String getVerticalStepBitMask(int index) {
        return switch (index) {
            case 0 -> "1000";
            case 1 -> "0100";
            case 2 -> "0010";
            case 3 -> "0001";
            default -> "0000";
        };
    }

    private boolean isStepBitSet(class_2680 state, int index) {
        return switch (index) {
            case 0 -> (Boolean)state.method_11654((class_2769)StepBlock.DOWN_FRONT);
            case 1 -> (Boolean)state.method_11654((class_2769)StepBlock.DOWN_BACK);
            case 2 -> (Boolean)state.method_11654((class_2769)StepBlock.UP_FRONT);
            case 3 -> (Boolean)state.method_11654((class_2769)StepBlock.UP_BACK);
            default -> false;
        };
    }

    private String getStepBitMask(int index) {
        return switch (index) {
            case 0 -> "1000";
            case 1 -> "0100";
            case 2 -> "0010";
            case 3 -> "0001";
            default -> "0000";
        };
    }

    private boolean isVerticalSlabBitSet(class_2680 state, int index) {
        if (state.method_26204() instanceof MixedVerticalSlabBlock) {
            return index == 0 ? ((Boolean)state.method_11654((class_2769)MixedVerticalSlabBlock.NEGATIVE)).booleanValue() : ((Boolean)state.method_11654((class_2769)MixedVerticalSlabBlock.POSITIVE)).booleanValue();
        }
        return false;
    }

    private boolean isSlabBitSet(class_2680 state, int index) {
        if (state.method_26204() instanceof MixedSlabBlock) {
            return index == 0 ? ((Boolean)state.method_11654((class_2769)MixedSlabBlock.BOTTOM)).booleanValue() : ((Boolean)state.method_11654((class_2769)MixedSlabBlock.TOP)).booleanValue();
        }
        return false;
    }

    private class_2350 rotateY(class_2350 dir, boolean rotate180, boolean rotate270) {
        if (dir == null) {
            return null;
        }
        if (dir.method_10166().method_10178() || !rotate180 && !rotate270) {
            return dir;
        }
        if (rotate180) {
            return dir.method_10153();
        }
        return dir.method_10160();
    }
}

