/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.network;

import java.util.List;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.network.ConvertBlockPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class NetworkHandler {
    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConvertBlockPacket.ID, (server, player, handler, buf, responseSender) -> {
            ConvertBlockPacket packet = ConvertBlockPacket.fromBuffer(buf);
            server.execute(() -> NetworkHandler.handleConvertBlock(player, packet));
        });
    }

    public static void sendConvertBlockPacket(class_2960 targetBlockId, int slot) {
        ConvertBlockPacket packet = new ConvertBlockPacket(targetBlockId, slot);
        ClientPlayNetworking.send((class_2960)ConvertBlockPacket.ID, (class_2540)packet.toBuffer());
    }

    private static void handleConvertBlock(class_3222 player, ConvertBlockPacket packet) {
        class_2487 nbt;
        int slot = packet.slot();
        class_2960 targetId = packet.targetBlockId();
        if (slot < 0 || slot >= player.method_31548().method_5439()) {
            Reshaped.LOGGER.warn("Invalid slot {} in convert block packet from {}", (Object)slot, (Object)player.method_5477().getString());
            return;
        }
        class_1799 currentStack = player.method_31548().method_5438(slot);
        class_1792 class_17922 = currentStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            Reshaped.LOGGER.warn("Slot {} does not contain a BlockItem for {}", (Object)slot, (Object)player.method_5477().getString());
            return;
        }
        class_1747 currentBlockItem = (class_1747)class_17922;
        class_2248 currentBlock = currentBlockItem.method_7711();
        if (Reshaped.MATRIX == null || !Reshaped.MATRIX.hasBlock(currentBlock)) {
            Reshaped.LOGGER.warn("Block {} is not in the matrix for {}", (Object)currentBlock, (Object)player.method_5477().getString());
            return;
        }
        class_2248 targetBlock = (class_2248)class_7923.field_41175.method_10223(targetId);
        if (targetBlock == class_2246.field_10124) {
            Reshaped.LOGGER.warn("Target block {} does not exist for {}", (Object)targetId, (Object)player.method_5477().getString());
            return;
        }
        List<class_2248> column = Reshaped.MATRIX.getColumn(currentBlock);
        if (!column.contains(targetBlock)) {
            Reshaped.LOGGER.warn("Target block {} is not in the same column as {} for {}", new Object[]{targetId, currentBlock, player.method_5477().getString()});
            return;
        }
        int count = currentStack.method_7947();
        class_1799 newStack = new class_1799((class_1935)targetBlock.method_8389(), count);
        if (currentStack.method_7985() && (nbt = currentStack.method_7969()) != null) {
            newStack.method_7980(nbt.method_10553());
        }
        player.method_31548().method_5447(slot, newStack);
        Reshaped.LOGGER.debug("Converted {} x{} to {} for {}", new Object[]{currentBlock, count, targetBlock, player.method_5477().getString()});
    }
}

