/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.block.Step.OxidizableStepBlock;
import net.f3rr3.reshaped.block.Step.StepBlock;
import net.f3rr3.reshaped.mixin.AxeItemAccessor;
import net.f3rr3.reshaped.mixin.HoneycombItemAccessor;
import net.f3rr3.reshaped.registry.BlockVariantType;
import net.f3rr3.reshaped.util.BlockMatrix;
import net.f3rr3.reshaped.util.RuntimeResourceGenerator;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5955;
import net.minecraft.class_7923;

public class StepVariant
implements BlockVariantType {
    private static final Map<class_2248, StepBlock> BASE_TO_STEP = new HashMap<class_2248, StepBlock>();

    @Override
    public String getName() {
        return "step";
    }

    @Override
    public void register(class_2248 baseBlock, BlockMatrix matrix) {
        StepBlock step;
        class_2248 existingBase;
        class_2960 baseId = class_7923.field_41175.method_10221((Object)baseBlock);
        String baseName = baseId.method_12832().replace("_planks", "").replace("_block", "");
        String path = baseName + "_step";
        class_2960 id = new class_2960("reshaped", path);
        class_2248 existingAtId = (class_2248)class_7923.field_41175.method_10223(id);
        if (existingAtId != class_2246.field_10124 && (existingBase = matrix.getBaseBlock(existingAtId)) != null && existingBase != baseBlock) {
            path = baseId.method_12836() + "_" + baseId.method_12832() + "_step";
            id = new class_2960("reshaped", path);
        }
        if (class_7923.field_41175.method_10223(id) != class_2246.field_10124) {
            class_2248 existing = (class_2248)class_7923.field_41175.method_10223(id);
            if (existing instanceof StepBlock) {
                StepBlock step2 = (StepBlock)existing;
                BASE_TO_STEP.putIfAbsent(baseBlock, step2);
                List<class_2248> variants = matrix.getMatrix().get(baseBlock);
                if (variants != null && !variants.contains((Object)step2)) {
                    variants.add(step2);
                }
            }
            return;
        }
        class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)baseBlock);
        if (baseBlock instanceof class_5955) {
            class_5955 oxidizable = (class_5955)baseBlock;
            step = new OxidizableStepBlock((class_5955.class_5811)oxidizable.method_33622(), settings);
        } else {
            step = new StepBlock(settings);
        }
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)((Object)step));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)new class_1747((class_2248)step, new class_1792.class_1793()));
        matrix.addVariant(baseBlock, step, true);
        matrix.setReason(step, "Dynamically registered Step Block for " + baseBlock.method_9518().getString());
        BASE_TO_STEP.put(baseBlock, step);
        Reshaped.LOGGER.info("Registered step for: {}", (Object)baseId);
        FlammableBlockRegistry flammableRegistry = FlammableBlockRegistry.getDefaultInstance();
        FlammableBlockRegistry.Entry flammableEntry = (FlammableBlockRegistry.Entry)flammableRegistry.get(baseBlock);
        if (flammableEntry != null) {
            flammableRegistry.add((class_2248)step, flammableEntry.getBurnChance(), flammableEntry.getSpreadChance());
        }
        this.linkRelations(baseBlock, step);
        for (Map.Entry<class_2248, StepBlock> entry : BASE_TO_STEP.entrySet()) {
            if (entry.getKey() == baseBlock) continue;
            this.linkRelations(entry.getKey(), entry.getValue());
        }
    }

    private void linkRelations(class_2248 base, StepBlock step) {
        Optional nextOxidation = class_5955.method_34737((class_2248)base);
        if (nextOxidation.isPresent() && BASE_TO_STEP.containsKey(nextOxidation.get())) {
            StepBlock nextStep = BASE_TO_STEP.get(nextOxidation.get());
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)step, (class_2248)nextStep);
        }
        try {
            Map unwaxedToWaxed = (Map)HoneycombItemAccessor.getUnwaxedToWaxedSupplier().get();
            class_2248 waxedBase = (class_2248)unwaxedToWaxed.get(base);
            if (waxedBase != null && BASE_TO_STEP.containsKey(waxedBase)) {
                Object waxedStep = BASE_TO_STEP.get(waxedBase);
                OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)step, waxedStep);
            }
            for (Map.Entry entry : unwaxedToWaxed.entrySet()) {
                if (entry.getValue() != base || !BASE_TO_STEP.containsKey(entry.getKey())) continue;
                StepBlock unwaxedStep = BASE_TO_STEP.get(entry.getKey());
                OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)unwaxedStep, (class_2248)step);
            }
        }
        catch (Exception unwaxedToWaxed) {
            // empty catch block
        }
        try {
            Map<class_2248, class_2248> strippedBlocks = AxeItemAccessor.getStrippedBlocks();
            class_2248 strippedBase = strippedBlocks.get(base);
            if (strippedBase != null && BASE_TO_STEP.containsKey(strippedBase)) {
                StepBlock strippedStep = BASE_TO_STEP.get(strippedBase);
                StrippableBlockRegistry.register((class_2248)step, (class_2248)strippedStep);
            }
            for (Map.Entry<class_2248, class_2248> entry : strippedBlocks.entrySet()) {
                if (entry.getValue() != base || !BASE_TO_STEP.containsKey(entry.getKey())) continue;
                StepBlock unstrippedStep = BASE_TO_STEP.get(entry.getKey());
                StrippableBlockRegistry.register((class_2248)unstrippedStep, (class_2248)step);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String generateModelJson(String path, class_2248 block) {
        if (path.contains("_step") && !path.contains("_vertical_step")) {
            String mask = RuntimeResourceGenerator.extractMaskSuffix(path);
            boolean[] segments = RuntimeResourceGenerator.parseMaskOrDefault(mask, true, false, false, false);
            class_2248 targetBlock = RuntimeResourceGenerator.resolveBlockForPath(path, block);
            class_2248 baseBlock = Reshaped.MATRIX.getBaseBlock(targetBlock);
            if (baseBlock != null) {
                Map<String, String> textures = RuntimeResourceGenerator.getModelTextures(baseBlock);
                return RuntimeResourceGenerator.generateStepModelForSegments(segments[0], segments[1], segments[2], segments[3], textures);
            }
        }
        return null;
    }
}

