/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.util.BlockMatrix;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class VariantCompleter {
    public static void completeVariant(class_2248 base, BlockMatrix matrix) {
        class_2960 id;
        String path;
        String cleanBase;
        if (base == class_2246.field_10124) {
            return;
        }
        List<class_2248> variants = matrix.getMatrix().get(base);
        if (variants == null) {
            return;
        }
        boolean hasSlab = false;
        boolean hasStair = false;
        for (class_2248 v : variants) {
            if (v instanceof class_2482) {
                hasSlab = true;
            }
            if (!(v instanceof class_2510)) continue;
            hasStair = true;
        }
        class_2960 baseId = class_7923.field_41175.method_10221((Object)base);
        String baseNamespace = baseId.method_12836();
        if (!hasSlab) {
            class_2248 existingSlab = VariantCompleter.findExistingVariant(baseId.method_12832(), "slab", baseNamespace);
            if (existingSlab != null) {
                if (!variants.contains(existingSlab)) {
                    variants.add(existingSlab);
                    matrix.setReason(existingSlab, "Adopted existing slab variant: " + String.valueOf(class_7923.field_41175.method_10221((Object)existingSlab)));
                    Reshaped.LOGGER.info("Adopted existing slab: {} for {}", (Object)class_7923.field_41175.method_10221((Object)existingSlab), (Object)baseId);
                }
            } else {
                cleanBase = baseId.method_12832().replace("_planks", "").replace("_block", "");
                path = cleanBase + "_slab";
                id = new class_2960("reshaped", path);
                if (class_7923.field_41175.method_10223(id) != class_2246.field_10124) {
                    path = baseNamespace + "_" + baseId.method_12832() + "_slab";
                    id = new class_2960("reshaped", path);
                }
                if (class_7923.field_41175.method_10223(id) == class_2246.field_10124) {
                    class_2482 slab = new class_2482(class_4970.class_2251.method_9630((class_4970)base));
                    class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)slab);
                    class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)new class_1747((class_2248)slab, new class_1792.class_1793()));
                    variants.add((class_2248)slab);
                    matrix.setReason((class_2248)slab, "Dynamically registered slab variant for " + base.method_9518().getString());
                    Reshaped.LOGGER.info("Registered new slab: {}", (Object)id);
                }
            }
        }
        if (!hasStair) {
            class_2248 existingStairs = VariantCompleter.findExistingVariant(baseId.method_12832(), "stairs", baseNamespace);
            if (existingStairs != null) {
                if (!variants.contains(existingStairs)) {
                    variants.add(existingStairs);
                    matrix.setReason(existingStairs, "Adopted existing stairs variant: " + String.valueOf(class_7923.field_41175.method_10221((Object)existingStairs)));
                    Reshaped.LOGGER.info("Adopted existing stairs: {} for {}", (Object)class_7923.field_41175.method_10221((Object)existingStairs), (Object)baseId);
                }
            } else {
                cleanBase = baseId.method_12832().replace("_planks", "").replace("_block", "");
                path = cleanBase + "_stairs";
                id = new class_2960("reshaped", path);
                if (class_7923.field_41175.method_10223(id) != class_2246.field_10124) {
                    path = baseNamespace + "_" + baseId.method_12832() + "_stairs";
                    id = new class_2960("reshaped", path);
                }
                if (class_7923.field_41175.method_10223(id) == class_2246.field_10124) {
                    class_2510 stairs = new class_2510(base.method_9564(), class_4970.class_2251.method_9630((class_4970)base));
                    class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)stairs);
                    class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)new class_1747((class_2248)stairs, new class_1792.class_1793()));
                    variants.add((class_2248)stairs);
                    matrix.setReason((class_2248)stairs, "Dynamically registered stairs variant for " + base.method_9518().getString());
                    Reshaped.LOGGER.info("Registered new stairs: {}", (Object)id);
                }
            }
        }
    }

    private static class_2248 findExistingVariant(String baseName, String suffix, String baseNamespace) {
        class_2248 block;
        class_2960 id2;
        List<String> variantsToTry = VariantCompleter.getVariantsToTry(baseName, suffix);
        for (String candidatePath : variantsToTry) {
            id2 = new class_2960(baseNamespace, candidatePath);
            block = (class_2248)class_7923.field_41175.method_10223(id2);
            if (block == class_2246.field_10124 || !VariantCompleter.isValidVariant(block, suffix)) continue;
            return block;
        }
        if (!baseNamespace.equals("minecraft")) {
            for (String candidatePath : variantsToTry) {
                id2 = new class_2960("minecraft", candidatePath);
                block = (class_2248)class_7923.field_41175.method_10223(id2);
                if (block == class_2246.field_10124 || !VariantCompleter.isValidVariant(block, suffix)) continue;
                return block;
            }
        }
        HashSet<String> targetPaths = new HashSet<String>(variantsToTry);
        for (class_2960 id2 : class_7923.field_41175.method_10235()) {
            if (!targetPaths.contains(id2.method_12832()) || !VariantCompleter.isValidVariant(block = (class_2248)class_7923.field_41175.method_10223(id2), suffix)) continue;
            return block;
        }
        return null;
    }

    @NotNull
    private static List<String> getVariantsToTry(String baseName, String suffix) {
        ArrayList<String> variantsToTry = new ArrayList<String>();
        variantsToTry.add(baseName + "_" + suffix);
        variantsToTry.add(baseName.replace("_block", "") + "_" + suffix);
        variantsToTry.add(baseName.replace("_planks", "") + "_" + suffix);
        if (baseName.contains("copper") && !baseName.contains("cut_")) {
            variantsToTry.add(baseName.replace("copper", "cut_copper") + "_" + suffix);
        }
        variantsToTry.add(baseName.replace("bricks", "brick") + "_" + suffix);
        variantsToTry.add(baseName.replace("tiles", "tile") + "_" + suffix);
        variantsToTry.add(baseName.replace("shingles", "shingle") + "_" + suffix);
        if (baseName.endsWith("s")) {
            variantsToTry.add(baseName.substring(0, baseName.length() - 1) + "_" + suffix);
        }
        return variantsToTry;
    }

    private static boolean isValidVariant(class_2248 block, String suffix) {
        if (suffix.equals("slab") && block instanceof class_2482) {
            return true;
        }
        return suffix.equals("stairs") && block instanceof class_2510;
    }
}

