/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.registry;

import java.util.ArrayList;
import java.util.List;
import net.f3rr3.reshaped.registry.BlockVariantType;
import net.f3rr3.reshaped.registry.CornerVariant;
import net.f3rr3.reshaped.registry.StepVariant;
import net.f3rr3.reshaped.registry.VerticalSlabVariant;
import net.f3rr3.reshaped.registry.VerticalStairsVariant;
import net.f3rr3.reshaped.registry.VerticalStepVariant;
import net.f3rr3.reshaped.util.BlockMatrix;
import net.minecraft.class_2248;

public class VariantRegistry {
    private static final List<BlockVariantType> VARIANTS = new ArrayList<BlockVariantType>();

    public static void registerAll(class_2248 baseBlock, BlockMatrix matrix) {
        for (BlockVariantType variant : VARIANTS) {
            variant.register(baseBlock, matrix);
        }
    }

    public static String generateModelJson(String path, class_2248 block) {
        for (BlockVariantType variant : VARIANTS) {
            String json = variant.generateModelJson(path, block);
            if (json == null) continue;
            return json;
        }
        return null;
    }

    public static List<BlockVariantType> getVariants() {
        return VARIANTS;
    }

    static {
        VARIANTS.add(new VerticalSlabVariant());
        VARIANTS.add(new VerticalStairsVariant());
        VARIANTS.add(new CornerVariant());
        VARIANTS.add(new StepVariant());
        VARIANTS.add(new VerticalStepVariant());
    }
}

