/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public class BlockMatrix {
    private final Map<class_2248, List<class_2248>> matrix = new LinkedHashMap<class_2248, List<class_2248>>();
    private final Map<class_2248, String> reasons = new HashMap<class_2248, String>();
    private final Set<class_2248> allBlocks = new HashSet<class_2248>();
    private final Map<class_2248, class_2248> variantToBase = new HashMap<class_2248, class_2248>();

    public void refresh() {
        if (this.matrix.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<class_2248, List<class_2248>>> entries = new ArrayList<Map.Entry<class_2248, List<class_2248>>>(this.matrix.entrySet());
        entries.sort(Comparator.comparing(e -> class_7923.field_41175.method_10221((Object)((class_2248)e.getKey())).toString()));
        this.matrix.clear();
        this.variantToBase.clear();
        this.allBlocks.clear();
        for (Map.Entry entry : entries) {
            class_2248 base = (class_2248)entry.getKey();
            List variants = (List)entry.getValue();
            variants.sort(Comparator.comparing(b -> class_7923.field_41175.method_10221(b).toString()));
            this.matrix.put(base, variants);
            this.allBlocks.add(base);
            for (class_2248 variant : variants) {
                this.variantToBase.put(variant, base);
                this.allBlocks.add(variant);
            }
        }
    }

    public class_2248 getBaseBlock(class_2248 variant) {
        return this.variantToBase.get(variant);
    }

    public void addVariant(class_2248 baseBlock, class_2248 variant, boolean shouldRefresh) {
        List existing = this.matrix.computeIfAbsent(baseBlock, k -> new ArrayList());
        if (!existing.contains(variant)) {
            existing.add(variant);
            if (shouldRefresh) {
                this.refresh();
            }
        }
    }

    public void addColumn(class_2248 baseBlock, List<class_2248> variants, boolean shouldRefresh) {
        List existing = this.matrix.getOrDefault(baseBlock, new ArrayList());
        boolean added = false;
        for (class_2248 v : variants) {
            if (existing.contains(v)) continue;
            existing.add(v);
            added = true;
        }
        if (added || !this.matrix.containsKey(baseBlock)) {
            this.matrix.put(baseBlock, existing);
            if (shouldRefresh) {
                this.refresh();
            }
        }
    }

    public void setReason(class_2248 block, String reason) {
        this.reasons.put(block, reason);
    }

    public String getReason(class_2248 block) {
        return this.reasons.getOrDefault(block, "No reason specified");
    }

    public boolean hasBlock(class_2248 block) {
        return this.allBlocks.contains(block);
    }

    public List<class_2248> getColumn(class_2248 block) {
        for (Map.Entry<class_2248, List<class_2248>> entry : this.matrix.entrySet()) {
            if (!entry.getKey().equals(block) && !entry.getValue().contains(block)) continue;
            ArrayList<class_2248> column = new ArrayList<class_2248>();
            column.add(entry.getKey());
            column.addAll((Collection)entry.getValue());
            column.sort(Comparator.comparing(b -> b.getClass().getSimpleName()).thenComparing(b -> class_7923.field_41175.method_10221(b).toString()));
            return column;
        }
        return Collections.emptyList();
    }

    public Map<class_2248, List<class_2248>> getMatrix() {
        return Collections.unmodifiableMap(this.matrix);
    }
}

