/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.registry.VariantCompleter;
import net.f3rr3.reshaped.registry.VariantRegistry;
import net.f3rr3.reshaped.util.BlockMatrix;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlockRegistryScanner {
    public static void init(BlockMatrix matrix) {
        ArrayList<class_2248> initialBlocks = new ArrayList<class_2248>();
        for (class_2248 block2 : class_7923.field_41175) {
            initialBlocks.add(block2);
        }
        for (class_2248 block2 : initialBlocks) {
            BlockRegistryScanner.processBlock(block2, matrix, false);
        }
        matrix.refresh();
        RegistryEntryAddedCallback.event((class_2378)class_7923.field_41175).register((rawId, id, block) -> BlockRegistryScanner.processBlock(block, matrix, true));
    }

    private static void processBlock(class_2248 block, BlockMatrix matrix, boolean shouldRefresh) {
        String namespace;
        String path;
        class_2960 id;
        if (block == null || block == class_2246.field_10124) {
            return;
        }
        if (matrix.hasBlock(block)) {
            return;
        }
        class_2248 base = null;
        String reason = null;
        if (block instanceof class_2510) {
            try {
                Field field = class_2510.class.getDeclaredField("baseBlockState");
                field.setAccessible(true);
                class_2680 state = (class_2680)field.get(block);
                if (state != null && state.method_26204() != null && state.method_26204() != class_2246.field_10124) {
                    base = state.method_26204();
                    reason = "Classified as Stairs based on its baseBlockState (" + base.method_9518().getString() + ")";
                }
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        if (block instanceof class_2482) {
            try {
                List<String> candidates;
                id = class_7923.field_41175.method_10221((Object)block);
                path = id.method_12832();
                namespace = id.method_12836();
                String baseName = null;
                if (path.endsWith("_slab")) {
                    baseName = path.substring(0, path.length() - 5);
                } else if (path.endsWith("_slabs")) {
                    baseName = path.substring(0, path.length() - 6);
                }
                if (baseName != null && (base = BlockRegistryScanner.findBaseCandidate(namespace, candidates = BlockRegistryScanner.buildCandidates(baseName))) != null) {
                    reason = "Classified as Slab based on its name matching base block: " + String.valueOf(class_7923.field_41175.method_10221((Object)base));
                }
            }
            catch (Exception e) {
                Reshaped.LOGGER.error("Failed to resolve base block for slab: {}", (Object)block, (Object)e);
            }
        }
        if (!(block instanceof class_2510) && !(block instanceof class_2482)) {
            try {
                List<String> candidates;
                id = class_7923.field_41175.method_10221((Object)block);
                path = id.method_12832();
                namespace = id.method_12836();
                String[] suffixes = new String[]{"_fence", "_wall", "_trapdoor", "_door", "_pressure_plate", "_fence_gate", "_button", "_bars"};
                String baseName = null;
                for (String suffix : suffixes) {
                    if (!path.endsWith(suffix)) continue;
                    baseName = path.substring(0, path.length() - suffix.length());
                    break;
                }
                if (baseName != null && (base = BlockRegistryScanner.findBaseCandidate(namespace, candidates = BlockRegistryScanner.buildCandidates(baseName))) != null) {
                    reason = "Classified as Other variant based on its name matching base block: " + String.valueOf(class_7923.field_41175.method_10221((Object)base));
                }
            }
            catch (Exception e) {
                Reshaped.LOGGER.error("Failed to resolve base block for other variant of block: {}", (Object)block, (Object)e);
            }
        }
        if (base != null && base != block && base != class_2246.field_10124 && !(base instanceof class_2482) && !(base instanceof class_2510)) {
            ArrayList<class_2248> variants = new ArrayList<class_2248>();
            variants.add(block);
            matrix.addColumn(base, variants, shouldRefresh);
            matrix.setReason(block, reason);
            matrix.setReason(base, "Base block for the group");
            VariantCompleter.completeVariant(base, matrix);
            VariantRegistry.registerAll(base, matrix);
            if (shouldRefresh) {
                matrix.refresh();
            }
        }
    }

    private static List<String> buildCandidates(String baseName) {
        return Arrays.asList(baseName + "_planks", baseName + "_block", baseName + "s", baseName.replace("_brick", "_bricks"), baseName.replace("_tile", "_tiles"), baseName.replace("_shingle", "_shingles"), baseName);
    }

    private static class_2248 findBaseCandidate(String namespace, List<String> candidates) {
        class_2248 base = BlockRegistryScanner.findBaseCandidateInNamespace(namespace, candidates);
        if (base == null && !namespace.equals("minecraft")) {
            base = BlockRegistryScanner.findBaseCandidateInNamespace("minecraft", candidates);
        }
        return base;
    }

    private static class_2248 findBaseCandidateInNamespace(String namespace, List<String> candidates) {
        for (String candidate : candidates) {
            class_2960 candidateId = new class_2960(namespace, candidate);
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(candidateId);
            if (block == class_2246.field_10124 || block instanceof class_2482 || block instanceof class_2510) continue;
            return block;
        }
        return null;
    }
}

