/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.util;

import net.f3rr3.reshaped.block.Corner.CornerBlock;
import net.f3rr3.reshaped.block.Step.StepBlock;
import net.f3rr3.reshaped.block.Template.MixedBlockEntity;
import net.f3rr3.reshaped.block.VerticalStep.VerticalStepBlock;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlockSegmentUtils {
    public static final class_2746[] CORNER_PROPERTIES = new class_2746[]{CornerBlock.DOWN_NW, CornerBlock.DOWN_NE, CornerBlock.DOWN_SW, CornerBlock.DOWN_SE, CornerBlock.UP_NW, CornerBlock.UP_NE, CornerBlock.UP_SW, CornerBlock.UP_SE};
    public static final class_2746[] VERTICAL_STEP_PROPERTIES = new class_2746[]{VerticalStepBlock.NORTH_WEST, VerticalStepBlock.NORTH_EAST, VerticalStepBlock.SOUTH_WEST, VerticalStepBlock.SOUTH_EAST};
    public static final class_2746[] STEP_PROPERTIES = new class_2746[]{StepBlock.DOWN_FRONT, StepBlock.DOWN_BACK, StepBlock.UP_FRONT, StepBlock.UP_BACK};
    public static final class_265 CORNER_DOWN_NW = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    public static final class_265 CORNER_DOWN_NE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    public static final class_265 CORNER_DOWN_SW = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    public static final class_265 CORNER_DOWN_SE = class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    public static final class_265 CORNER_UP_NW = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    public static final class_265 CORNER_UP_NE = class_2248.method_9541((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final class_265 CORNER_UP_SW = class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    public static final class_265 CORNER_UP_SE = class_2248.method_9541((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final class_265 VSTEP_NW = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    public static final class_265 VSTEP_NE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final class_265 VSTEP_SW = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    public static final class_265 VSTEP_SE = class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public static Quadrant getQuadrantFromHit(double hitX, double hitY, double hitZ, class_2350 side, boolean isPlacement) {
        double offset = isPlacement ? 0.05 : -0.05;
        double testX = hitX + (double)side.method_10148() * offset;
        double testY = hitY + (double)side.method_10164() * offset;
        double testZ = hitZ + (double)side.method_10165() * offset;
        testX = Math.max(0.001, Math.min(0.999, testX));
        testY = Math.max(0.001, Math.min(0.999, testY));
        testZ = Math.max(0.001, Math.min(0.999, testZ));
        boolean isUp = testY > 0.5;
        boolean isNorth = testZ < 0.5;
        boolean isWest = testX < 0.5;
        return new Quadrant(isUp, isNorth, isWest);
    }

    public static class_2746 getCornerProperty(Quadrant quadrant) {
        if (quadrant.isUp()) {
            if (!quadrant.isWest()) {
                return quadrant.isPlusZ() ? CornerBlock.UP_SE : CornerBlock.UP_NE;
            }
            return quadrant.isPlusZ() ? CornerBlock.UP_SW : CornerBlock.UP_NW;
        }
        if (!quadrant.isWest()) {
            return quadrant.isPlusZ() ? CornerBlock.DOWN_SE : CornerBlock.DOWN_NE;
        }
        return quadrant.isPlusZ() ? CornerBlock.DOWN_SW : CornerBlock.DOWN_NW;
    }

    public static class_2746 getVerticalStepProperty(Quadrant quadrant) {
        if (quadrant.isNorth()) {
            return quadrant.isWest() ? VerticalStepBlock.NORTH_WEST : VerticalStepBlock.NORTH_EAST;
        }
        return quadrant.isWest() ? VerticalStepBlock.SOUTH_WEST : VerticalStepBlock.SOUTH_EAST;
    }

    public static class_2746 getStepProperty(Quadrant quadrant, StepBlock.StepAxis axis) {
        boolean isFront;
        boolean bl = isFront = axis == StepBlock.StepAxis.NORTH_SOUTH ? quadrant.isNorth() : quadrant.isWest();
        if (quadrant.isUp()) {
            return isFront ? StepBlock.UP_FRONT : StepBlock.UP_BACK;
        }
        return isFront ? StepBlock.DOWN_FRONT : StepBlock.DOWN_BACK;
    }

    public static class_265 getStepShape(StepBlock.StepAxis axis, boolean isFront, boolean isDown) {
        double yMin = isDown ? 0.0 : 8.0;
        double yMax = isDown ? 8.0 : 16.0;
        double xMin = 0.0;
        double xMax = 16.0;
        double zMin = 0.0;
        double zMax = 16.0;
        if (axis == StepBlock.StepAxis.NORTH_SOUTH) {
            zMin = isFront ? 0.0 : 8.0;
            zMax = isFront ? 8.0 : 16.0;
        } else {
            xMin = isFront ? 0.0 : 8.0;
            xMax = isFront ? 8.0 : 16.0;
        }
        return class_2248.method_9541((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    public static class_265 buildStepShape(class_2680 state) {
        StepBlock.StepAxis axis = (StepBlock.StepAxis)((Object)state.method_11654(StepBlock.AXIS));
        class_265 shape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)StepBlock.DOWN_FRONT)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)BlockSegmentUtils.getStepShape(axis, true, true));
        }
        if (((Boolean)state.method_11654((class_2769)StepBlock.DOWN_BACK)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)BlockSegmentUtils.getStepShape(axis, false, true));
        }
        if (((Boolean)state.method_11654((class_2769)StepBlock.UP_FRONT)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)BlockSegmentUtils.getStepShape(axis, true, false));
        }
        if (((Boolean)state.method_11654((class_2769)StepBlock.UP_BACK)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)BlockSegmentUtils.getStepShape(axis, false, false));
        }
        return shape.method_1110() ? class_259.method_1077() : shape;
    }

    public static class_265 buildVerticalStepShape(class_2680 state) {
        class_265 shape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.NORTH_WEST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)VSTEP_NW);
        }
        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.NORTH_EAST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)VSTEP_NE);
        }
        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.SOUTH_WEST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)VSTEP_SW);
        }
        if (((Boolean)state.method_11654((class_2769)VerticalStepBlock.SOUTH_EAST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)VSTEP_SE);
        }
        return shape.method_1110() ? class_259.method_1077() : shape;
    }

    public static class_265 buildCornerShape(class_2680 state) {
        class_265 shape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)CornerBlock.DOWN_NW)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_DOWN_NW);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.DOWN_NE)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_DOWN_NE);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.DOWN_SW)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_DOWN_SW);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.DOWN_SE)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_DOWN_SE);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.UP_NW)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_UP_NW);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.UP_NE)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_UP_NE);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.UP_SW)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_UP_SW);
        }
        if (((Boolean)state.method_11654((class_2769)CornerBlock.UP_SE)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)CORNER_UP_SE);
        }
        return shape.method_1110() ? class_259.method_1077() : shape;
    }

    public static void fillMissingMaterials(MixedBlockEntity blockEntity, class_2680 state, class_2746[] properties, class_2960 materialId) {
        for (int i = 0; i < properties.length; ++i) {
            if (!((Boolean)state.method_11654((class_2769)properties[i])).booleanValue() || blockEntity.getMaterial(i) != null) continue;
            blockEntity.setMaterial(i, materialId);
        }
    }

    public static void fillMissingMaterialsFromItem(class_1799 itemStack, MixedBlockEntity blockEntity, class_2680 state, class_2746[] properties) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            BlockSegmentUtils.fillMissingMaterials(blockEntity, state, properties, class_7923.field_41175.method_10221((Object)blockItem.method_7711()));
        }
    }

    public static void fillMissingMaterialsFromItem(class_1937 world, class_2338 pos, class_2680 state, class_1799 itemStack, class_2746[] properties, Class<? extends MixedBlockEntity> entityClass) {
        class_2586 be = world.method_8321(pos);
        if (entityClass.isInstance(be)) {
            BlockSegmentUtils.fillMissingMaterialsFromItem(itemStack, entityClass.cast(be), state, properties);
        }
    }

    public record Quadrant(boolean isUp, boolean isNorth, boolean isWest) {
        public boolean isPlusX() {
            return !this.isWest;
        }

        public boolean isPlusZ() {
            return !this.isNorth;
        }
    }
}

