/*
 * Decompiled with CFR 0.152.
 */
package net.f3rr3.reshaped.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.f3rr3.reshaped.Reshaped;
import net.f3rr3.reshaped.block.Step.StepBlock;
import net.f3rr3.reshaped.block.VericalStairs.VerticalStairsBlock;
import net.f3rr3.reshaped.block.VerticalSlab.VerticalSlabBlock;
import net.f3rr3.reshaped.block.VerticalStep.VerticalStepBlock;
import net.f3rr3.reshaped.registry.VariantRegistry;
import net.minecraft.class_1086;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_7923;
import net.minecraft.class_813;

public class RuntimeResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<class_2248, Map<String, String>> TEXTURE_CACHE = new HashMap<class_2248, Map<String, String>>();

    public static String getTemplateType(class_2248 block, class_2960 id) {
        String path = id.method_12832();
        if (path.endsWith("_vertical_slab")) {
            return "vertical_slab";
        }
        if (path.endsWith("_vertical_stairs")) {
            return "vertical_stairs";
        }
        if (path.endsWith("_corner")) {
            return "corner";
        }
        if (path.endsWith("_vertical_step")) {
            return "vertical_step";
        }
        if (path.endsWith("_step")) {
            return "step";
        }
        if (block instanceof class_2510) {
            return "stairs";
        }
        if (block instanceof class_2482) {
            return "slab";
        }
        return null;
    }

    public static String serializeState(class_2680 state) {
        StringBuilder sb = new StringBuilder();
        ArrayList<class_2769> properties = new ArrayList<class_2769>(state.method_28501());
        properties.sort(Comparator.comparing(class_2769::method_11899));
        for (int i = 0; i < properties.size(); ++i) {
            class_2769 property = (class_2769)properties.get(i);
            sb.append(property.method_11899()).append("=").append(state.method_11654(property).toString().toLowerCase());
            if (i >= properties.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static JsonElement findMatchingVariant(JsonObject variants, String stateString) {
        if (variants.has(stateString)) {
            return variants.get(stateString);
        }
        for (String key : variants.keySet()) {
            if (!key.isEmpty() && !RuntimeResourceGenerator.matches(stateString, key)) continue;
            return variants.get(key);
        }
        return null;
    }

    private static boolean matches(String state, String variant) {
        String[] variantParts;
        for (String part : variantParts = variant.split(",")) {
            if (state.contains(part)) continue;
            return false;
        }
        return true;
    }

    public static class_813 parseVariant(JsonElement elem) {
        if (elem.isJsonArray()) {
            return RuntimeResourceGenerator.parseVariant(elem.getAsJsonArray().get(0));
        }
        JsonObject obj = elem.getAsJsonObject();
        String model = obj.get("model").getAsString();
        int x = obj.has("x") ? obj.get("x").getAsInt() : 0;
        int y = obj.has("y") ? obj.get("y").getAsInt() : 0;
        boolean uvlock = obj.has("uvlock") && obj.get("uvlock").getAsBoolean();
        int weight = obj.has("weight") ? obj.get("weight").getAsInt() : 1;
        class_1086 rotation = class_1086.method_4699((int)x, (int)y);
        return new class_813(new class_2960(model), rotation.method_3509(), uvlock, weight);
    }

    public static String generateModelJson(String cleanPath) {
        class_2248 baseBlock;
        String variantJson;
        if (Reshaped.MATRIX == null) {
            return null;
        }
        String path = RuntimeResourceGenerator.normalizePath(cleanPath);
        if (path.startsWith("item/")) {
            String itemPath = path.substring(5);
            return "{\"parent\":\"reshaped:block/" + itemPath + "\"}";
        }
        String blockPath = path;
        if (blockPath.startsWith("block/")) {
            blockPath = blockPath.substring(6);
        }
        if (blockPath.startsWith("mixed_") && !blockPath.equals("mixed_placeholder")) {
            return "{\"parent\":\"reshaped:block/mixed_placeholder\"}";
        }
        String baseBlockPath = blockPath;
        if (blockPath.contains("_corner_") && blockPath.length() >= 9) {
            int lastUnderscore = blockPath.lastIndexOf("_");
            if (blockPath.length() - lastUnderscore == 9) {
                baseBlockPath = blockPath.substring(0, lastUnderscore);
            }
        }
        if ((variantJson = VariantRegistry.generateModelJson(blockPath, (class_2248)class_7923.field_41175.method_10223(new class_2960("reshaped", baseBlockPath = baseBlockPath.replace("_up", "").replace("_down", "").replace("_plus_x", "").replace("_minus_x", "").replace("_plus_y", "").replace("_minus_y", "").replace("_north", "").replace("_south", "").replace("_east", "").replace("_west", "").replaceAll("_\\d{4}$", ""))))) != null) {
            return variantJson;
        }
        class_2960 blockId = new class_2960("reshaped", blockPath.replace("_top", "").replace("_inner", "").replace("_outer", "").replace("_2", "").replace("_3", ""));
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
        class_2248 class_22482 = baseBlock = Reshaped.MATRIX != null ? Reshaped.MATRIX.getBaseBlock(block) : null;
        if (baseBlock != null) {
            Map<String, String> textures = RuntimeResourceGenerator.getModelTextures(baseBlock);
            if (block instanceof VerticalSlabBlock) {
                return RuntimeResourceGenerator.generateModelFromTemplate("block/vertical_slab", textures);
            }
            if (block instanceof VerticalStairsBlock) {
                return RuntimeResourceGenerator.generateModelFromTemplate("block/vertical_stairs", textures);
            }
            if (block instanceof VerticalStepBlock) {
                String mask = RuntimeResourceGenerator.extractMaskSuffix(blockPath);
                if (mask != null) {
                    boolean[] segments = RuntimeResourceGenerator.parseMaskOrDefault(mask, true, false, false, false);
                    return RuntimeResourceGenerator.generateVerticalStepModelForSegments(segments[0], segments[1], segments[2], segments[3], textures);
                }
                return RuntimeResourceGenerator.generateVerticalStepModelForSegments(true, false, false, false, textures);
            }
            if (block instanceof StepBlock) {
                String mask = RuntimeResourceGenerator.extractMaskSuffix(blockPath);
                if (mask != null) {
                    boolean[] segments = RuntimeResourceGenerator.parseMaskOrDefault(mask, true, false, false, false);
                    return RuntimeResourceGenerator.generateStepModelForSegments(segments[0], segments[1], segments[2], segments[3], textures);
                }
                return RuntimeResourceGenerator.generateStepModelForSegments(true, false, false, false, textures);
            }
            if (block instanceof class_2482) {
                if (blockPath.endsWith("_top")) {
                    return RuntimeResourceGenerator.generateSimpleModel("minecraft:block/slab_top", textures);
                }
                return RuntimeResourceGenerator.generateSimpleModel("minecraft:block/slab", textures);
            }
            if (block instanceof class_2510) {
                if (blockPath.endsWith("_inner")) {
                    return RuntimeResourceGenerator.generateSimpleModel("minecraft:block/inner_stairs", textures);
                }
                if (blockPath.endsWith("_outer")) {
                    return RuntimeResourceGenerator.generateSimpleModel("minecraft:block/outer_stairs", textures);
                }
                return RuntimeResourceGenerator.generateSimpleModel("minecraft:block/stairs", textures);
            }
        }
        return null;
    }

    public static String generateSimpleModel(String parent, Map<String, String> textures) {
        JsonObject root = new JsonObject();
        root.addProperty("parent", parent);
        JsonObject texturesObj = new JsonObject();
        RuntimeResourceGenerator.applyTextures(texturesObj, textures);
        root.add("textures", (JsonElement)texturesObj);
        return root.toString();
    }

    public static String generateModelFromTemplate(String templatePath, Map<String, String> textures) {
        JsonObject template = RuntimeResourceGenerator.loadTemplateJson("models/" + templatePath + ".json");
        if (template == null) {
            return null;
        }
        if (template.has("textures")) {
            RuntimeResourceGenerator.applyTextures(template.getAsJsonObject("textures"), textures);
        }
        return template.toString();
    }

    private static void analyzeFaceTextures(class_2960 modelId, Map<String, String> textures) {
        try {
            JsonObject fullModel = RuntimeResourceGenerator.loadModelHierarchy(modelId);
            if (fullModel == null || !fullModel.has("elements")) {
                return;
            }
            JsonArray elements = fullModel.getAsJsonArray("elements");
            if (elements.isEmpty()) {
                return;
            }
            JsonObject firstElement = elements.get(0).getAsJsonObject();
            if (!firstElement.has("faces")) {
                return;
            }
            JsonObject faces = firstElement.getAsJsonObject("faces");
            HashMap<String, String> faceToTexture = new HashMap<String, String>();
            for (String face : new String[]{"up", "down", "north", "south", "east", "west"}) {
                JsonObject faceObj;
                if (!faces.has(face) || !(faceObj = faces.getAsJsonObject(face)).has("texture")) continue;
                String textureRef = faceObj.get("texture").getAsString();
                faceToTexture.put(face, textureRef);
            }
            HashMap<String, String> resolvedTextures = new HashMap<String, String>();
            for (Map.Entry entry : faceToTexture.entrySet()) {
                String key;
                String textureRef = (String)entry.getValue();
                if (!textureRef.startsWith("#") || !textures.containsKey(key = textureRef.substring(1))) continue;
                resolvedTextures.put((String)entry.getKey(), textures.get(key));
            }
            if (resolvedTextures.containsKey("up")) {
                textures.putIfAbsent("top", (String)resolvedTextures.get("up"));
            }
            if (resolvedTextures.containsKey("down")) {
                textures.putIfAbsent("bottom", (String)resolvedTextures.get("down"));
            }
            for (String face : new String[]{"north", "south", "east", "west"}) {
                if (!resolvedTextures.containsKey(face)) continue;
                textures.putIfAbsent("side", (String)resolvedTextures.get(face));
                break;
            }
            if (!textures.containsKey("particle")) {
                if (textures.containsKey("side")) {
                    textures.put("particle", textures.get("side"));
                } else if (textures.containsKey("all")) {
                    textures.put("particle", textures.get("all"));
                }
            }
        }
        catch (Exception e) {
            Reshaped.LOGGER.warn("Failed to analyze face textures for model: {}", (Object)modelId, (Object)e);
        }
    }

    private static JsonObject loadModelHierarchy(class_2960 modelId) {
        JsonObject merged = new JsonObject();
        JsonObject current = RuntimeResourceGenerator.loadModelJson(modelId);
        if (current == null) {
            return null;
        }
        if (current.has("parent")) {
            class_2960 parentId;
            String parentPath = current.get("parent").getAsString();
            if (parentPath.contains(":")) {
                String[] parts = parentPath.split(":");
                parentId = new class_2960(parts[0], "models/" + parts[1] + ".json");
            } else {
                parentId = new class_2960("minecraft", "models/" + parentPath + ".json");
            }
            JsonObject parentModel = RuntimeResourceGenerator.loadModelHierarchy(parentId);
            if (parentModel != null) {
                for (Map.Entry entry : parentModel.entrySet()) {
                    merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }
        for (Map.Entry entry : current.entrySet()) {
            merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return merged;
    }

    private static JsonObject loadModelJson(class_2960 modelId) {
        Optional resource = class_310.method_1551().method_1478().method_14486(modelId);
        if (resource.isPresent()) {
            JsonObject jsonObject;
            InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());
            try {
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reader.close();
            return jsonObject;
        }
        return null;
    }

    public static void applyTextures(JsonObject texObj, Map<String, String> textures) {
        String side;
        String all;
        for (Map.Entry<String, String> entry : textures.entrySet()) {
            texObj.addProperty(entry.getKey(), entry.getValue());
        }
        String end = textures.get("end");
        if (end != null) {
            if (!texObj.has("top")) {
                texObj.addProperty("top", end);
            }
            if (!texObj.has("bottom")) {
                texObj.addProperty("bottom", end);
            }
        }
        if ((all = textures.get("all")) != null) {
            if (!texObj.has("top")) {
                texObj.addProperty("top", all);
            }
            if (!texObj.has("bottom")) {
                texObj.addProperty("bottom", all);
            }
            if (!texObj.has("side")) {
                texObj.addProperty("side", all);
            }
        }
        if ((side = textures.get("side")) != null) {
            if (!texObj.has("top")) {
                texObj.addProperty("top", side);
            }
            if (!texObj.has("bottom")) {
                texObj.addProperty("bottom", side);
            }
        }
        if (!texObj.has("particle")) {
            if (texObj.has("side")) {
                texObj.addProperty("particle", texObj.get("side").getAsString());
            } else if (texObj.has("top")) {
                texObj.addProperty("particle", texObj.get("top").getAsString());
            } else if (texObj.has("all")) {
                texObj.addProperty("particle", texObj.get("all").getAsString());
            }
        }
    }

    private static JsonObject createSegmentElement(double x1, double y1, double z1, double x2, double y2, double z2, Map<String, String> cullfaces) {
        JsonObject element = new JsonObject();
        RuntimeResourceGenerator.setFromTo(element, x1, y1, z1, x2, y2, z2);
        JsonObject faces = new JsonObject();
        element.add("faces", (JsonElement)faces);
        RuntimeResourceGenerator.addFace(faces, "north", "#side", cullfaces.get("north"), new double[]{16.0 - x2, 16.0 - y2, 16.0 - x1, 16.0 - y1});
        RuntimeResourceGenerator.addFace(faces, "south", "#side", cullfaces.get("south"), new double[]{x1, 16.0 - y2, x2, 16.0 - y1});
        RuntimeResourceGenerator.addFace(faces, "up", "#top", cullfaces.get("up"), new double[]{x1, z1, x2, z2});
        RuntimeResourceGenerator.addFace(faces, "down", "#bottom", cullfaces.get("down"), new double[]{x1, 16.0 - z2, x2, 16.0 - z1});
        RuntimeResourceGenerator.addFace(faces, "east", "#side", cullfaces.get("east"), new double[]{16.0 - z2, 16.0 - y2, 16.0 - z1, 16.0 - y1});
        RuntimeResourceGenerator.addFace(faces, "west", "#side", cullfaces.get("west"), new double[]{z1, 16.0 - y2, z2, 16.0 - y1});
        return element;
    }

    public static String generateStepModelForSegments(boolean downFront, boolean downBack, boolean upFront, boolean upBack, Map<String, String> textures) {
        return RuntimeResourceGenerator.generateSegmentedModel("models/block/step.json", textures, elements -> {
            if (downFront) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(8.0, 0.0, 0.0, 16.0, 8.0, 16.0, Map.of("north", "north", "south", "south", "east", "east", "down", "down")));
            }
            if (downBack) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(0.0, 0.0, 0.0, 8.0, 8.0, 16.0, Map.of("north", "north", "south", "south", "west", "west", "down", "down")));
            }
            if (upFront) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(8.0, 8.0, 0.0, 16.0, 16.0, 16.0, Map.of("north", "north", "south", "south", "up", "up", "east", "east")));
            }
            if (upBack) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(0.0, 8.0, 0.0, 8.0, 16.0, 16.0, Map.of("north", "north", "south", "south", "up", "up", "west", "west")));
            }
        });
    }

    public static String generateVerticalStepModelForSegments(boolean nw, boolean ne, boolean sw, boolean se, Map<String, String> textures) {
        return RuntimeResourceGenerator.generateSegmentedModel("models/block/vertical_step.json", textures, elements -> {
            if (nw) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(0.0, 0.0, 0.0, 8.0, 16.0, 8.0, Map.of("north", "north", "west", "west", "up", "up", "down", "down")));
            }
            if (ne) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(8.0, 0.0, 0.0, 16.0, 16.0, 8.0, Map.of("north", "north", "east", "east", "up", "up", "down", "down")));
            }
            if (sw) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(0.0, 0.0, 8.0, 8.0, 16.0, 16.0, Map.of("south", "south", "west", "west", "up", "up", "down", "down")));
            }
            if (se) {
                elements.add((JsonElement)RuntimeResourceGenerator.createSegmentElement(8.0, 0.0, 8.0, 16.0, 16.0, 16.0, Map.of("south", "south", "east", "east", "up", "up", "down", "down")));
            }
        });
    }

    private static String generateSegmentedModel(String templatePath, Map<String, String> textures, Consumer<JsonArray> elementBuilder) {
        JsonObject template = RuntimeResourceGenerator.loadTemplateJson(templatePath);
        if (template == null) {
            return null;
        }
        if (template.has("textures")) {
            RuntimeResourceGenerator.applyTextures(template.getAsJsonObject("textures"), textures);
        }
        JsonArray elements = new JsonArray();
        template.add("elements", (JsonElement)elements);
        elementBuilder.accept(elements);
        return template.toString();
    }

    private static void addFace(JsonObject faces, String side, String texture, String cullface, double[] uv) {
        JsonObject face = new JsonObject();
        face.addProperty("texture", texture);
        if (cullface != null) {
            face.addProperty("cullface", cullface);
        }
        JsonArray uvArray = new JsonArray();
        for (double v : uv) {
            uvArray.add((Number)v);
        }
        face.add("uv", (JsonElement)uvArray);
        faces.add(side, (JsonElement)face);
    }

    private static void setFromTo(JsonObject element, double x1, double y1, double z1, double x2, double y2, double z2) {
        JsonArray from = new JsonArray();
        from.add((Number)x1);
        from.add((Number)y1);
        from.add((Number)z1);
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)x2);
        to.add((Number)y2);
        to.add((Number)z2);
        element.add("to", (JsonElement)to);
    }

    public static String loadTemplate(String path) {
        class_2960 id = new class_2960("reshaped", "templates/" + path);
        Optional resource = class_310.method_1551().method_1478().method_14486(id);
        if (resource.isPresent()) {
            String string;
            InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());
            try {
                int read;
                StringBuilder builder = new StringBuilder();
                char[] buffer = new char[4096];
                while ((read = reader.read(buffer)) != -1) {
                    builder.append(buffer, 0, read);
                }
                string = builder.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Reshaped.LOGGER.error("Failed to load template: {}", (Object)id, (Object)e);
                }
            }
            reader.close();
            return string;
        }
        return null;
    }

    public static JsonObject loadTemplateJson(String path) {
        String template = RuntimeResourceGenerator.loadTemplate(path);
        if (template != null) {
            try {
                return JsonParser.parseString((String)template).getAsJsonObject();
            }
            catch (Exception e) {
                Reshaped.LOGGER.error("Failed to parse template JSON: {}", (Object)path, (Object)e);
            }
        }
        return null;
    }

    public static String generateBlockStateJson(String templateName, Map<String, String> placeholders) {
        String template = RuntimeResourceGenerator.loadTemplate("blockstates/" + templateName + ".json");
        if (template == null) {
            return null;
        }
        String result = template;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace("{{" + entry.getKey() + "}}", entry.getValue());
        }
        return result;
    }

    public static Map<String, String> getModelTextures(class_2248 block) {
        if (TEXTURE_CACHE.containsKey(block)) {
            return new HashMap<String, String>(TEXTURE_CACHE.get(block));
        }
        HashMap<String, String> textures = new HashMap<String, String>();
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        class_2960 modelId = new class_2960(blockId.method_12836(), "models/block/" + blockId.method_12832() + ".json");
        if (RuntimeResourceGenerator.loadTexturesFromModel(modelId, textures)) {
            RuntimeResourceGenerator.analyzeFaceTextures(modelId, textures);
            TEXTURE_CACHE.put(block, new HashMap<String, String>(textures));
            return textures;
        }
        class_2960 blockStateId = new class_2960(blockId.method_12836(), "blockstates/" + blockId.method_12832() + ".json");
        Optional blockStateResource = class_310.method_1551().method_1478().method_14486(blockStateId);
        if (blockStateResource.isPresent()) {
            try (InputStreamReader reader = new InputStreamReader(((class_3298)blockStateResource.get()).method_14482());){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                String variantModel = null;
                if (json.has("variants")) {
                    JsonObject variants = json.getAsJsonObject("variants");
                    if (variants.has("")) {
                        JsonObject variant;
                        JsonObject jsonObject = variant = variants.get("").isJsonObject() ? variants.getAsJsonObject("") : null;
                        if (variant != null && variant.has("model")) {
                            variantModel = variant.get("model").getAsString();
                        }
                    } else {
                        JsonObject variant;
                        String firstKey = (String)variants.keySet().iterator().next();
                        if (variants.get(firstKey).isJsonObject() && (variant = variants.getAsJsonObject(firstKey)).has("model")) {
                            variantModel = variant.get("model").getAsString();
                        }
                    }
                }
                if (variantModel != null) {
                    class_2960 redirectedModelId = new class_2960(variantModel.contains(":") ? variantModel.split(":")[0] : "minecraft", "models/" + (variantModel.contains(":") ? variantModel.split(":")[1] : variantModel) + ".json");
                    RuntimeResourceGenerator.loadTexturesFromModel(redirectedModelId, textures);
                    RuntimeResourceGenerator.analyzeFaceTextures(redirectedModelId, textures);
                }
            }
            catch (Exception e) {
                Reshaped.LOGGER.error("Failed to read block state for block: {}", (Object)blockId, (Object)e);
            }
        }
        TEXTURE_CACHE.put(block, new HashMap<String, String>(textures));
        return textures;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadTexturesFromModel(class_2960 modelId, Map<String, String> textures) {
        Optional resource = class_310.method_1551().method_1478().method_14486(modelId);
        if (!resource.isPresent()) return false;
        try (InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!json.has("textures")) return false;
            JsonObject textureJson = json.getAsJsonObject("textures");
            textureJson.entrySet().forEach(entry -> textures.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Reshaped.LOGGER.error("Failed to read model: {}", (Object)modelId, (Object)e);
        }
        return false;
    }

    public static String normalizePath(String path) {
        String normalized = path;
        if (normalized.startsWith("models/")) {
            normalized = normalized.substring(7);
        }
        if (normalized.endsWith(".json")) {
            normalized = normalized.substring(0, normalized.length() - 5);
        }
        return normalized;
    }

    public static String extractMaskSuffix(String path) {
        if (path.matches(".*_\\d{4}$")) {
            return path.substring(path.length() - 4);
        }
        return null;
    }

    public static boolean[] parseMaskOrDefault(String mask, boolean first, boolean second, boolean third, boolean fourth) {
        if (mask == null || mask.length() != 4) {
            return new boolean[]{first, second, third, fourth};
        }
        return new boolean[]{mask.charAt(0) == '1', mask.charAt(1) == '1', mask.charAt(2) == '1', mask.charAt(3) == '1'};
    }

    public static String stripMaskSuffix(String path) {
        if (path.matches(".*_\\d{4}$")) {
            return path.substring(0, path.length() - 5);
        }
        return path;
    }

    public static class_2248 resolveBlockForPath(String path, class_2248 block) {
        String basePath = RuntimeResourceGenerator.stripMaskSuffix(path);
        if (basePath.equals(path)) {
            return block;
        }
        class_2960 blockId = new class_2960("reshaped", basePath);
        return (class_2248)class_7923.field_41175.method_10223(blockId);
    }

    private static class_2248 findBaseBlock(class_2248 variant) {
        if (Reshaped.MATRIX == null) {
            return null;
        }
        for (Map.Entry<class_2248, List<class_2248>> entry : Reshaped.MATRIX.getMatrix().entrySet()) {
            if (!entry.getValue().contains(variant)) continue;
            return entry.getKey();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_2960 resolveBlockModelId(class_2248 block) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        class_2960 directModelId = new class_2960(blockId.method_12836(), "models/block/" + blockId.method_12832() + ".json");
        Optional directResource = class_310.method_1551().method_1478().method_14486(directModelId);
        if (directResource.isPresent()) {
            return new class_2960(blockId.method_12836(), "block/" + blockId.method_12832());
        }
        class_2960 blockStateId = new class_2960(blockId.method_12836(), "blockstates/" + blockId.method_12832() + ".json");
        Optional bsResource = class_310.method_1551().method_1478().method_14486(blockStateId);
        if (!bsResource.isPresent()) return null;
        try (InputStreamReader reader = new InputStreamReader(((class_3298)bsResource.get()).method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String variantModel = null;
            if (json.has("variants")) {
                JsonObject variant;
                String firstKey;
                JsonObject variants = json.getAsJsonObject("variants");
                if (variants.has("")) {
                    JsonObject variant2;
                    JsonObject jsonObject = variant2 = variants.get("").isJsonObject() ? variants.getAsJsonObject("") : null;
                    if (variant2 != null && variant2.has("model")) {
                        variantModel = variant2.get("model").getAsString();
                    }
                } else if (!variants.keySet().isEmpty() && variants.get(firstKey = (String)variants.keySet().iterator().next()).isJsonObject() && (variant = variants.getAsJsonObject(firstKey)).has("model")) {
                    variantModel = variant.get("model").getAsString();
                }
            }
            if (variantModel == null) return null;
            String namespace = variantModel.contains(":") ? variantModel.split(":")[0] : "minecraft";
            String modelPath = variantModel.contains(":") ? variantModel.split(":")[1] : variantModel;
            class_2960 class_29602 = new class_2960(namespace, modelPath);
            return class_29602;
        }
        catch (Exception e) {
            Reshaped.LOGGER.error("Failed to resolve model for block: {}", (Object)blockId, (Object)e);
        }
        return null;
    }
}

