/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.retrodamageindicators;

import com.github.alexmodguy.retrodamageindicators.Config;
import com.github.alexmodguy.retrodamageindicators.RetroDamageIndicators;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class DamageIndicatorParticle
extends Particle {
    private static final ParticleGroup GROUP = new ParticleGroup(1000);
    private final Component damageString;
    private final boolean heal;
    private float scale;
    private float prevScale;

    protected DamageIndicatorParticle(ClientLevel clientLevel, double x, double y, double z, double damageAmount, boolean heal) {
        super(clientLevel, x, y, z);
        this.lifetime = 15 + clientLevel.random.nextInt(5);
        Object text = (Boolean)Config.INSTANCE.healthDecimals.get() != false ? String.valueOf(RetroDamageIndicators.roundHealth((float)damageAmount)).replace(".0", "") : "" + (int)damageAmount;
        this.damageString = Component.literal((String)text);
        this.heal = heal;
        this.scale = 1.0f;
        this.yd = (double)0.2f + Math.random() * (double)0.2f;
        this.gravity = 1.3f;
    }

    public void tick() {
        super.tick();
        float ageScaled = (float)this.age / (float)this.lifetime;
        this.prevScale = this.scale;
        this.scale = 1.0f - ageScaled;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 cameraPos = camera.getPosition();
        double x = (float)Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x);
        double y = (float)Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
        double z = (float)Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z);
        int color = this.heal ? 65280 : 0xFF0000;
        int colorOutline = this.heal ? 13056 : 0x330000;
        float scale = this.getScale(partialTicks) * 0.035f;
        PoseStack posestack = new PoseStack();
        posestack.pushPose();
        posestack.translate(x - cameraPos.x, y - cameraPos.y, z - cameraPos.z);
        posestack.mulPose(camera.rotation());
        posestack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        float f = -Minecraft.getInstance().font.width((FormattedText)this.damageString) / 2;
        posestack.scale(scale, scale, scale);
        posestack.translate(0.0f, -2.0f, 0.0f);
        if (((Boolean)Config.INSTANCE.damageParticleOutline.get()).booleanValue()) {
            Minecraft.getInstance().font.drawInBatch8xOutline(this.damageString.getVisualOrderText(), f, 0.0f, color, colorOutline, posestack.last().pose(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0);
        } else {
            Minecraft.getInstance().font.drawInBatch(this.damageString.getVisualOrderText(), f, 0.0f, color, false, posestack.last().pose(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        multibuffersource$buffersource.endBatch();
        posestack.popPose();
    }

    private float getScale(float partialTicks) {
        return this.prevScale + (this.scale - this.prevScale) * partialTicks;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public Optional<ParticleGroup> getParticleGroup() {
        return Optional.of(GROUP);
    }
}

