/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.retrodamageindicators;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.Tags;

public enum MobTypes {
    PLAYER,
    UNDEAD,
    UNDEAD_ANIMAL,
    ANIMAL,
    WATER_ANIMAL,
    AMBIENT,
    MONSTER,
    WATER_MONSTER,
    ARTHROPOD,
    ARTHROPOD_MONSTER,
    WATER_ARTHROPOD,
    GOLEM,
    VILLAGER,
    ILLAGER,
    UNKNOWN,
    BOSS;

    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"retrodamageindicators", (String)("textures/gui/mob_types/" + this.name().toLowerCase(Locale.ROOT) + ".png"));

    public static MobTypes getTypeFor(Entity entity) {
        if (entity instanceof Player) {
            return PLAYER;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.getType().is(Tags.EntityTypes.BOSSES)) {
                return BOSS;
            }
            if (living.getType().is(EntityTypeTags.AQUATIC)) {
                return living instanceof Enemy ? WATER_MONSTER : WATER_ANIMAL;
            }
            if (living.getType().is(EntityTypeTags.UNDEAD)) {
                return living instanceof Enemy ? UNDEAD : UNDEAD_ANIMAL;
            }
            if (living.getType().is(EntityTypeTags.ARTHROPOD)) {
                return living instanceof WaterAnimal || living.canBreatheUnderwater() ? WATER_ARTHROPOD : (living instanceof Enemy ? ARTHROPOD_MONSTER : ARTHROPOD);
            }
            if (living.getType().is(EntityTypeTags.ILLAGER)) {
                return ILLAGER;
            }
            if (living instanceof AbstractGolem) {
                return GOLEM;
            }
            if (living instanceof Npc) {
                return VILLAGER;
            }
            if (living instanceof Enemy) {
                return MONSTER;
            }
            if (living instanceof AmbientCreature) {
                return AMBIENT;
            }
            if (living instanceof Mob) {
                return ANIMAL;
            }
        }
        return UNKNOWN;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

