/*
 * Decompiled with CFR 0.152.
 */
package com.mobexcavation;

import com.mobexcavation.MobExcavationConfig;
import com.mobexcavation.MobExcavationKeyHandler;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="mobexcavation")
public class MobExcavation {
    public static final String MODID = "mobexcavation";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MobExcavation(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MobExcavationConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Mob Excavation mod loaded successfully!");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Mob Excavation client setup complete!");
    }

    @Mod.EventBusSubscriber(modid="mobexcavation", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || !player.m_20148_().equals(mc.f_91074_.m_20148_())) {
                return;
            }
            if (!MobExcavationKeyHandler.EXCAVATE_KEY.m_90857_()) {
                LOGGER.info("Key not pressed");
                return;
            }
            LivingEntity targetEntity = event.getEntity();
            if (targetEntity instanceof Player) {
                return;
            }
            float damage = event.getAmount();
            LOGGER.info("CLIENT Starting excavation with damage: {} on entity: {}", (Object)Float.valueOf(damage), (Object)targetEntity.getClass().getSimpleName());
            Class<?> targetType = targetEntity.getClass();
            AABB searchArea = new AABB(targetEntity.m_20185_() - MobExcavationConfig.searchRadius, targetEntity.m_20186_() - MobExcavationConfig.searchRadius, targetEntity.m_20189_() - MobExcavationConfig.searchRadius, targetEntity.m_20185_() + MobExcavationConfig.searchRadius, targetEntity.m_20186_() + MobExcavationConfig.searchRadius, targetEntity.m_20189_() + MobExcavationConfig.searchRadius);
            List nearbyEntities = player.m_9236_().m_45976_(LivingEntity.class, searchArea);
            LOGGER.info("Found {} nearby entities", (Object)nearbyEntities.size());
            int damagedCount = 0;
            for (LivingEntity entity2 : nearbyEntities) {
                if (entity2 == targetEntity || !entity2.getClass().equals(targetType) || entity2 instanceof Player || !entity2.m_6084_() || !MobExcavationConfig.isMobAllowed(entity2)) continue;
                entity2.m_6469_(player.m_269291_().m_269075_(player), damage);
                ++damagedCount;
                LOGGER.info("CLIENT Damaged entity: {}", (Object)entity2.getClass().getSimpleName());
            }
            if (damagedCount > 0) {
                ItemStack weapon;
                if (MobExcavationConfig.toolDamage && !player.m_7500_() && (weapon = player.m_21205_()).m_41763_()) {
                    weapon.m_41622_(damagedCount, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
                if (MobExcavationConfig.toolExhaustion && !player.m_7500_()) {
                    player.m_36399_(0.1f * (float)damagedCount);
                }
            }
            LOGGER.info("CLIENT Total entities damaged: {}", (Object)damagedCount);
        }
    }
}

