/*
 * Decompiled with CFR 0.152.
 */
package com.mobexcavation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="mobexcavation", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobExcavationConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue MAX_MOBS = BUILDER.comment("Maximum number of mobs to kill at once").defineInRange("maxMobs", 64, 1, 1000);
    private static final ForgeConfigSpec.DoubleValue SEARCH_RADIUS = BUILDER.comment("Search radius for finding similar mobs").defineInRange("searchRadius", 2.0, 1.0, 64.0);
    private static final ForgeConfigSpec.BooleanValue TOOL_DAMAGE = BUILDER.comment("Whether tools should take damage when excavating mobs").define("toolDamage", true);
    private static final ForgeConfigSpec.BooleanValue TOOL_EXHAUSTION = BUILDER.comment("Whether player should get exhausted when excavating mobs").define("toolExhaustion", true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ALLOWED_WEAPONS = BUILDER.comment("List of allowed weapons for mob excavation").defineListAllowEmpty("allowedWeapons", List.of("minecraft:wooden_sword", "minecraft:stone_sword", "minecraft:iron_sword", "minecraft:golden_sword", "minecraft:diamond_sword", "minecraft:netherite_sword", "minecraft:bow", "minecraft:crossbow", "minecraft:trident"), MobExcavationConfig::validateItemName);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_MOBS = BUILDER.comment("List of mobs that cannot be excavated").defineListAllowEmpty("blacklistedMobs", List.of("minecraft:wither", "minecraft:ender_dragon"), MobExcavationConfig::validateEntityName);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int maxMobs;
    public static double searchRadius;
    public static boolean toolDamage;
    public static boolean toolExhaustion;
    public static Set<Item> allowedWeapons;
    public static Set<String> blacklistedMobs;

    private static boolean validateItemName(Object obj) {
        if (obj instanceof String) {
            String itemName = (String)obj;
            try {
                return ForgeRegistries.ITEMS.containsKey(ResourceLocation.m_135820_((String)itemName));
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean validateEntityName(Object obj) {
        if (obj instanceof String) {
            String entityName = (String)obj;
            try {
                return ForgeRegistries.ENTITY_TYPES.containsKey(ResourceLocation.m_135820_((String)entityName));
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        maxMobs = (Integer)MAX_MOBS.get();
        searchRadius = (Double)SEARCH_RADIUS.get();
        toolDamage = (Boolean)TOOL_DAMAGE.get();
        toolExhaustion = (Boolean)TOOL_EXHAUSTION.get();
        allowedWeapons = ((List)ALLOWED_WEAPONS.get()).stream().map(itemName -> {
            try {
                return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)itemName));
            }
            catch (Exception e) {
                return null;
            }
        }).filter(item -> item != null).collect(Collectors.toSet());
        blacklistedMobs = ((List)BLACKLISTED_MOBS.get()).stream().collect(Collectors.toSet());
    }

    public static boolean isWeaponAllowed(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (allowedWeapons.contains(item)) {
            return true;
        }
        return item instanceof SwordItem || item instanceof TridentItem || item instanceof BowItem || item instanceof CrossbowItem;
    }

    public static boolean isMobAllowed(LivingEntity entity) {
        ResourceLocation entityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return entityType != null && !blacklistedMobs.contains(entityType.toString());
    }
}

