/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.autumnal.client.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.autumnal.procedures.CutinDisplayOverlayIngameProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CutinOverlay {
    private static final int FADE_TIME = 60;
    private static final int HOLD_TIME = 100;
    private static int timer = 0;
    private static boolean active = false;
    private static Phase phase = Phase.FADE_IN;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer entity = mc.f_91074_;
        if (entity == null) {
            return;
        }
        if (CutinDisplayOverlayIngameProcedure.execute((Entity)entity) && !active) {
            active = true;
            timer = 0;
            phase = Phase.FADE_IN;
        }
        if (!active) {
            return;
        }
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        float alpha = 1.0f;
        switch (phase) {
            case FADE_IN: {
                alpha = (float)timer / 60.0f;
                if (++timer < 60) break;
                timer = 0;
                phase = Phase.HOLD;
                break;
            }
            case HOLD: {
                alpha = 1.0f;
                if (++timer < 100) break;
                timer = 0;
                phase = Phase.FADE_OUT;
                break;
            }
            case FADE_OUT: {
                alpha = 1.0f - (float)timer / 60.0f;
                if (++timer < 60) break;
                active = false;
                timer = 0;
                return;
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        event.getGuiGraphics().m_280163_(new ResourceLocation("autumnal:textures/screens/cutin.png"), w / 2 - 252, h / 2 - 115, 0.0f, 0.0f, 500, 140, 500, 140);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static enum Phase {
        FADE_IN,
        HOLD,
        FADE_OUT;

    }
}

