/*
 * Decompiled with CFR 0.152.
 */
package me.branchpanic.mods.stockpile.content.client.gui;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.branchpanic.mods.stockpile.api.upgrade.Upgrade;
import me.branchpanic.mods.stockpile.api.upgrade.UpgradeContainer;
import me.branchpanic.mods.stockpile.api.upgrade.UpgradeItem;
import me.branchpanic.mods.stockpile.content.client.gui.OverlayTextComponent;
import me.branchpanic.mods.stockpile.content.client.gui.TextOverlayRenderer;
import me.branchpanic.mods.stockpile.content.client.gui.UpgradeOverlaysKt;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/branchpanic/mods/stockpile/content/client/gui/UpgradeOverlayRenderer;", "Lme/branchpanic/mods/stockpile/content/client/gui/TextOverlayRenderer;", "()V", "getLines", "", "Lme/branchpanic/mods/stockpile/content/client/gui/OverlayTextComponent;", "world", "Lnet/minecraft/world/World;", "heldItem", "Lnet/minecraft/item/ItemStack;", "selectedPos", "Lnet/minecraft/util/math/BlockPos;", "stockpile"})
public final class UpgradeOverlayRenderer
implements TextOverlayRenderer {
    @Override
    @NotNull
    public List<OverlayTextComponent> getLines(@NotNull class_1937 world, @NotNull class_1799 heldItem, @NotNull class_2338 selectedPos) {
        OverlayTextComponent status;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)heldItem, (String)"heldItem");
        Intrinsics.checkParameterIsNotNull((Object)selectedPos, (String)"selectedPos");
        class_2586 blockEntity = world.method_8321(selectedPos);
        if (!(heldItem.method_7909() instanceof UpgradeItem) || !(blockEntity instanceof UpgradeContainer)) {
            return CollectionsKt.emptyList();
        }
        class_1792 class_17922 = heldItem.method_7909();
        if (class_17922 == null) {
            throw new TypeCastException("null cannot be cast to non-null type me.branchpanic.mods.stockpile.api.upgrade.UpgradeItem");
        }
        Upgrade upgrade = ((UpgradeItem)class_17922).getUpgrade(heldItem);
        List<Upgrade> conflicts = upgrade.getConflictingUpgrades(((UpgradeContainer)blockEntity).getAppliedUpgrades());
        if (!((UpgradeContainer)blockEntity).isUpgradeTypeAllowed(upgrade)) {
            String string = class_1074.method_4662((String)"ui.stockpile.wrong_upgrade", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.translate(\"ui.stockpile.wrong_upgrade\")");
            return CollectionsKt.listOf((Object)new OverlayTextComponent(string, (int)0xFFFFFFFFL, (int)3774816802L));
        }
        List upgradeLines = UpgradeOverlaysKt.getUpgradeList$default((UpgradeContainer)blockEntity, conflicts, null, 4, null);
        Collection collection = conflicts;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String string = class_1074.method_4662((String)(conflicts.size() == 1 ? "ui.stockpile.upgrade_conflict" : "ui.stockpile.upgrade_conflicts"), (Object[])new Object[]{conflicts.size()});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.translate(\n        \u2026ts.size\n                )");
            status = new OverlayTextComponent(string, (int)0xFFFFFFFFL, (int)3774816802L);
            return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)status), (Iterable)upgradeLines);
        }
        if (((UpgradeContainer)blockEntity).getAppliedUpgrades().size() == ((UpgradeContainer)blockEntity).getMaxUpgrades()) {
            String string = class_1074.method_4662((String)"ui.stockpile.upgrades_maxed", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.translate(\"ui.stockpile.upgrades_maxed\")");
            Integer n = class_124.field_1054.method_532();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Formatting.YELLOW.colorValue!!");
            status = new OverlayTextComponent(string, n, 0, 4, null);
            return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)status), (Iterable)upgradeLines);
        }
        String string = class_1074.method_4662((String)"ui.stockpile.apply_upgrade", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.translate(\"ui.stockpile.apply_upgrade\")");
        Integer n = class_124.field_1060.method_532();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Formatting.GREEN.colorValue!!");
        status = new OverlayTextComponent(string, n, 0, 4, null);
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)status), (Iterable)upgradeLines);
    }

    @Override
    @Nullable
    public Integer getStatusColor(@NotNull class_1937 world, @NotNull class_1799 heldItem, @NotNull class_2338 selectedPos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)heldItem, (String)"heldItem");
        Intrinsics.checkParameterIsNotNull((Object)selectedPos, (String)"selectedPos");
        return TextOverlayRenderer.DefaultImpls.getStatusColor(this, world, heldItem, selectedPos);
    }

    @Override
    public void draw(@NotNull class_1937 world, @NotNull class_1799 heldItem, @NotNull class_2338 selectedPos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)heldItem, (String)"heldItem");
        Intrinsics.checkParameterIsNotNull((Object)selectedPos, (String)"selectedPos");
        TextOverlayRenderer.DefaultImpls.draw(this, world, heldItem, selectedPos);
    }
}

